/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.DeviceStateCache;
import com.google.common.base.Splitter;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledApkCache
implements Disposable {
    private final DeviceStateCache<InstallState> myCache = new DeviceStateCache(this);
    private String myDiagnosticOutput;

    public void dispose() {
    }

    public boolean isInstalled(@NotNull IDevice device, @NotNull File apk, @NotNull String pkgName) throws IOException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledApkCache", "isInstalled"));
        }
        if (apk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apk", "com/android/tools/idea/run/InstalledApkCache", "isInstalled"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledApkCache", "isInstalled"));
        }
        InstallState state = this.myCache.get(device, pkgName);
        if (state == null) {
            return false;
        }
        String lastUpdateTime = this.getLastUpdateTime(device, pkgName);
        return lastUpdateTime != null && lastUpdateTime.equals(state.lastUpdateTime) && state.hash.equals((Object)InstalledApkCache.hash(apk));
    }

    public void setInstalled(@NotNull IDevice device, @NotNull File apk, @NotNull String pkgName) throws IOException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledApkCache", "setInstalled"));
        }
        if (apk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apk", "com/android/tools/idea/run/InstalledApkCache", "setInstalled"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledApkCache", "setInstalled"));
        }
        String lastUpdateTime = this.getLastUpdateTime(device, pkgName);
        if (lastUpdateTime == null) {
            String msg = String.format("Unexpected error: package manager reports that package %1$s has not been installed: %2$s", pkgName, StringUtil.notNullize((String)this.myDiagnosticOutput));
            Logger.getInstance(InstalledApkCache.class).warn(msg);
            return;
        }
        this.myCache.put(device, pkgName, new InstallState(InstalledApkCache.hash(apk), lastUpdateTime));
    }

    @NotNull
    private static HashCode hash(@NotNull File apk) throws IOException {
        if (apk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "apk", "com/android/tools/idea/run/InstalledApkCache", "hash"));
        }
        HashCode hashCode = Files.hash((File)apk, (HashFunction)Hashing.goodFastHash((int)32));
        if (hashCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/InstalledApkCache", "hash"));
        }
        return hashCode;
    }

    void deviceDisconnected(IDevice device) {
        this.myCache.deviceDisconnected(device);
    }

    @Nullable
    String getLastUpdateTime(@NotNull IDevice device, @NotNull String pkgName) {
        String output;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledApkCache", "getLastUpdateTime"));
        }
        if (pkgName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkgName", "com/android/tools/idea/run/InstalledApkCache", "getLastUpdateTime"));
        }
        boolean deviceHasPackage = false;
        this.myDiagnosticOutput = null;
        try {
            output = this.executeShellCommand(device, "dumpsys package " + pkgName, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.myDiagnosticOutput = String.format("Error executing 'dumpsys package %1$s:\n%2$s'", pkgName, e.getMessage());
            return null;
        }
        Iterable lines = Splitter.on((String)"\n").split((CharSequence)output);
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("Package [")) continue;
            int startIndex = line.indexOf(91);
            int endIndex = line.indexOf(93);
            if (startIndex <= 0 || endIndex <= startIndex) break;
            deviceHasPackage = pkgName.equals(line.substring(startIndex + 1, endIndex));
            break;
        }
        if (!deviceHasPackage) {
            this.myDiagnosticOutput = String.format("Expected string 'Package [%1$s]' not found in output: %2$s", pkgName, output);
            return null;
        }
        for (String line : lines) {
            if (!(line = line.trim()).startsWith("lastUpdateTime")) continue;
            return line;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    protected String executeShellCommand(@NotNull IDevice device, @NotNull String cmd, long timeout, @NotNull TimeUnit timeUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, InterruptedException {
        void timeUnit2;
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/InstalledApkCache", "executeShellCommand"));
        }
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/android/tools/idea/run/InstalledApkCache", "executeShellCommand"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/android/tools/idea/run/InstalledApkCache", "executeShellCommand"));
        }
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        device.executeShellCommand(cmd, (IShellOutputReceiver)receiver);
        latch.await(timeout, (TimeUnit)timeUnit2);
        return receiver.getOutput();
    }

    private static class InstallState {
        @NotNull
        public final HashCode hash;
        @Nullable
        public final String lastUpdateTime;

        public InstallState(@NotNull HashCode hash, @Nullable String lastUpdateTime) {
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/android/tools/idea/run/InstalledApkCache$InstallState", "<init>"));
            }
            this.hash = hash;
            this.lastUpdateTime = lastUpdateTime;
        }
    }
}

