/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.ManualTargetChooser;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetPickerDialog;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowChooserTarget
extends DeployTarget<State> {
    private DeployTargetPickerDialog.Result myResult;

    @Override
    @NotNull
    public String getId() {
        String string = TargetSelectionMode.SHOW_DIALOG.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ShowChooserTarget", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if ("Show Device Chooser Dialog" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ShowChooserTarget", "getDisplayName"));
        }
        return "Show Device Chooser Dialog";
    }

    @Override
    @NotNull
    public State createState() {
        State state = new State();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ShowChooserTarget", "createState"));
        }
        return state;
    }

    @Override
    public boolean requiresRuntimePrompt(@NotNull State deployTargetState) {
        if (deployTargetState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargetState", "com/android/tools/idea/run/editor/ShowChooserTarget", "requiresRuntimePrompt"));
        }
        return true;
    }

    @Override
    public boolean showPrompt(Executor executor, @NotNull ExecutionEnvironment env, AndroidFacet facet, DeviceCount deviceCount, boolean androidTests, @NotNull Map<String, DeployTargetState> deployTargetStates, int runConfigId, ProcessHandlerConsolePrinter printer) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/ShowChooserTarget", "showPrompt"));
        }
        if (deployTargetStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargetStates", "com/android/tools/idea/run/editor/ShowChooserTarget", "showPrompt"));
        }
        State showChooserState = (State)deployTargetStates.get(this.getId());
        List<DeployTarget> applicableTargets = ShowChooserTarget.getTargetsProvidingRunProfileState(executor, androidTests);
        if (applicableTargets.isEmpty()) {
            DeviceTarget deviceTarget = new ManualTargetChooser(showChooserState, facet, runConfigId).getTarget(printer, deviceCount, executor instanceof DefaultDebugExecutor);
            if (deviceTarget == null) {
                return false;
            }
            this.myResult = DeployTargetPickerDialog.Result.create(deviceTarget);
            return true;
        }
        DeployTargetPickerDialog dialog = new DeployTargetPickerDialog(runConfigId, facet, applicableTargets, deployTargetStates, printer);
        if (dialog.showAndGet()) {
            this.myResult = dialog.getResult();
            return true;
        }
        return false;
    }

    @NotNull
    private static List<DeployTarget> getTargetsProvidingRunProfileState(@NotNull Executor executor, boolean androidTests) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/ShowChooserTarget", "getTargetsProvidingRunProfileState"));
        }
        ArrayList targets = Lists.newArrayList();
        for (DeployTarget target : DeployTarget.getDeployTargets()) {
            if (!target.showInDevicePicker() || !target.isApplicable(androidTests) || !target.hasCustomRunProfileState(executor)) continue;
            targets.add(target);
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ShowChooserTarget", "getTargetsProvidingRunProfileState"));
        }
        return arrayList;
    }

    @Override
    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/editor/ShowChooserTarget", "createConfigurable"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/run/editor/ShowChooserTarget", "createConfigurable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/run/editor/ShowChooserTarget", "createConfigurable"));
        }
        return new ShowChooserConfigurable();
    }

    @Override
    public boolean hasCustomRunProfileState(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/ShowChooserTarget", "hasCustomRunProfileState"));
        }
        return this.myResult != null && this.myResult.hasRunProfile();
    }

    @Override
    public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull State state) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/ShowChooserTarget", "getRunProfileState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/ShowChooserTarget", "getRunProfileState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/ShowChooserTarget", "getRunProfileState"));
        }
        return this.myResult.getRunProfileState(executor, env, state);
    }

    @Override
    @Nullable
    public DeviceTarget getTarget(@NotNull State state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId, @NotNull ConsolePrinter printer) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/ShowChooserTarget", "getTarget"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/editor/ShowChooserTarget", "getTarget"));
        }
        if (deviceCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/android/tools/idea/run/editor/ShowChooserTarget", "getTarget"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/run/editor/ShowChooserTarget", "getTarget"));
        }
        return this.myResult.getDeviceTarget();
    }

    private static class ShowChooserConfigurable
    implements DeployTargetConfigurable<State> {
        private final JBCheckBox myCheckbox = new JBCheckBox("Use same device for future launches");

        @Override
        @Nullable
        public JComponent createComponent() {
            return this.myCheckbox;
        }

        @Override
        public void resetFrom(@NotNull State state, int uniqueID) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/ShowChooserTarget$ShowChooserConfigurable", "resetFrom"));
            }
            this.myCheckbox.setSelected(state.USE_LAST_SELECTED_DEVICE);
        }

        @Override
        public void applyTo(@NotNull State state, int uniqueID) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/ShowChooserTarget$ShowChooserConfigurable", "applyTo"));
            }
            state.USE_LAST_SELECTED_DEVICE = this.myCheckbox.isSelected();
        }
    }

    public static final class State
    extends DeployTargetState {
        public boolean USE_LAST_SELECTED_DEVICE;
    }
}

