/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.swing;

import com.android.tools.idea.ui.properties.core.StringProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class TextProperty
extends StringProperty
implements DocumentListener,
PropertyChangeListener {
    private final JComponent myComponent;

    public TextProperty(JTextComponent textComponent) {
        this.myComponent = textComponent;
        textComponent.getDocument().addDocumentListener(this);
    }

    public TextProperty(AbstractButton button) {
        this.myComponent = button;
        button.addPropertyChangeListener("text", this);
    }

    public TextProperty(JLabel label) {
        this.myComponent = label;
        label.addPropertyChangeListener("text", this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.notifyInvalidated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyInvalidated();
    }

    @Override
    @NotNull
    public String get() {
        if (this.myComponent instanceof JTextComponent) {
            String string = ((JTextComponent)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        if (this.myComponent instanceof AbstractButton) {
            String string = ((AbstractButton)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        if (this.myComponent instanceof JLabel) {
            String string = ((JLabel)this.myComponent).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/TextProperty", "get"));
            }
            return string;
        }
        throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
    }

    @Override
    protected void setDirectly(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/swing/TextProperty", "setDirectly"));
        }
        if (this.myComponent instanceof JTextComponent) {
            ((JTextComponent)this.myComponent).setText(value);
        } else if (this.myComponent instanceof AbstractButton) {
            ((AbstractButton)this.myComponent).setText(value);
        } else if (this.myComponent instanceof JLabel) {
            ((JLabel)this.myComponent).setText(value);
        } else {
            throw new IllegalStateException("Unexpected text component type: " + this.myComponent.getClass().getSimpleName());
        }
    }
}

