/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.EmptyXmlTag;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.refactoring.AndroidRefactoringContextProvider;
import org.jetbrains.annotations.NotNull;

public class AndroidDesignerRefactoringContextProvider
implements AndroidRefactoringContextProvider {
    @Override
    @NotNull
    public XmlTag[] getComponentTags(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/android/designer/AndroidDesignerRefactoringContextProvider", "getComponentTags"));
        }
        EditableArea area = (EditableArea)EditableArea.DATA_KEY.getData(dataContext);
        if (area == null) {
            if (XmlTag.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerRefactoringContextProvider", "getComponentTags"));
            }
            return XmlTag.EMPTY;
        }
        List selection = area.getSelection();
        if (selection.size() == 0) {
            if (XmlTag.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerRefactoringContextProvider", "getComponentTags"));
            }
            return XmlTag.EMPTY;
        }
        ArrayList<XmlTag> tags = new ArrayList<XmlTag>(selection.size());
        for (RadComponent component : selection) {
            if (!(component instanceof RadViewComponent)) {
                if (XmlTag.EMPTY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerRefactoringContextProvider", "getComponentTags"));
                }
                return XmlTag.EMPTY;
            }
            XmlTag tag = ((RadViewComponent)component).getTag();
            if (tag == null || tag.equals(EmptyXmlTag.INSTANCE)) {
                if (XmlTag.EMPTY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerRefactoringContextProvider", "getComponentTags"));
                }
                return XmlTag.EMPTY;
            }
            tags.add(tag);
        }
        XmlTag[] xmlTagArray = tags.toArray(new XmlTag[tags.size()]);
        if (xmlTagArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/AndroidDesignerRefactoringContextProvider", "getComponentTags"));
        }
        return xmlTagArray;
    }
}

