/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.intellij.android.designer.designSurface.DropToOperation;
import com.intellij.android.designer.designSurface.TreeDropToOperation;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.RadViewLayout;
import com.intellij.designer.componentTree.TreeEditOperation;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import java.util.Collections;
import java.util.List;

public class RadSingleChildrenViewLayout
extends RadViewLayout {
    public EditOperation processChildOperation(OperationContext context) {
        if (this.myContainer.getChildren().isEmpty() && (context.isCreate() || context.isPaste() || context.isAdd()) && context.getComponents().size() == 1) {
            if (context.isTree()) {
                if (TreeEditOperation.isTarget((RadComponent)this.myContainer, (OperationContext)context)) {
                    return new TreeDropToOperation(this.myContainer, context);
                }
                return null;
            }
            return new DropToOperation(this.myContainer, context);
        }
        return null;
    }

    @Override
    public void addContainerSelectionActions(DesignerEditorPanel designer, DefaultActionGroup actionGroup, List<? extends RadViewComponent> selection) {
        if (!this.myContainer.getChildren().isEmpty()) {
            RadComponent component = (RadComponent)this.myContainer.getChildren().get(0);
            RadLayout layout = component.getLayout();
            if (layout instanceof RadViewLayout) {
                ((RadViewLayout)layout).addContainerSelectionActions(designer, actionGroup, Collections.emptyList());
                if (component instanceof RadViewComponent) {
                    RadViewLayout.addFillActions(designer, actionGroup, Collections.singletonList((RadViewComponent)component));
                }
            }
        } else {
            super.addContainerSelectionActions(designer, actionGroup, selection);
        }
    }
}

