/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.layout.relative;

import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.relative.ConstraintType;
import com.intellij.designer.model.RadComponent;
import com.intellij.psi.xml.XmlAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyGraph {
    @NonNls
    private static final String KEY = "DependencyGraph";
    private static final String DEPENDENCY_FORMAT = "%1$s %2$s %3$s";
    private final Map<RadViewComponent, ViewData> myNodeToView = new HashMap<RadViewComponent, ViewData>();

    @NotNull
    public static DependencyGraph get(@NotNull RadViewComponent layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/android/designer/model/layout/relative/DependencyGraph", "get"));
        }
        DependencyGraph graph = (DependencyGraph)layout.getClientProperty(KEY);
        if (graph == null) {
            graph = new DependencyGraph(layout);
            layout.setClientProperty(KEY, graph);
        }
        DependencyGraph dependencyGraph = graph;
        if (dependencyGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/layout/relative/DependencyGraph", "get"));
        }
        return dependencyGraph;
    }

    public static void refresh(@NotNull RadViewComponent layout) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/android/designer/model/layout/relative/DependencyGraph", "refresh"));
        }
        layout.extractClientProperty(KEY);
    }

    private DependencyGraph(RadViewComponent layout) {
        List<RadComponent> nodes = layout.getChildren();
        String parentId = layout.getId();
        parentId = parentId != null ? LintUtils.stripIdPrefix((String)parentId) : "RelativeLayout";
        ViewData parentView = new ViewData(layout, parentId);
        this.myNodeToView.put(layout, parentView);
        HashMap<String, ViewData> idToView = new HashMap<String, ViewData>();
        idToView.put(parentId, parentView);
        for (RadViewComponent child : RadViewComponent.getViewComponents(nodes)) {
            String id = child.getId();
            if (id != null) {
                id = LintUtils.stripIdPrefix((String)id);
            }
            ViewData view = new ViewData(child, id);
            this.myNodeToView.put(child, view);
            if (id == null) continue;
            idToView.put(id, view);
        }
        for (ViewData view : this.myNodeToView.values()) {
            for (XmlAttribute attribute : view.node.getTag().getAttributes()) {
                String name = attribute.getLocalName();
                ConstraintType type = ConstraintType.fromAttribute(name);
                if (type == null) continue;
                String value = attribute.getValue();
                if (type.targetParent) {
                    if (!"true".equals(value)) continue;
                    Constraint constraint = new Constraint(type, view, parentView);
                    view.dependsOn.add(constraint);
                    parentView.dependedOnBy.add(constraint);
                    continue;
                }
                String targetId = LintUtils.stripIdPrefix((String)value);
                ViewData target = (ViewData)idToView.get(targetId);
                if (target == view || target == null) continue;
                Constraint constraint = new Constraint(type, view, target);
                view.dependsOn.add(constraint);
                target.dependedOnBy.add(constraint);
            }
        }
    }

    public ViewData getView(RadViewComponent node) {
        return this.myNodeToView.get((Object)node);
    }

    public Set<RadViewComponent> dependsOn(Collection<? extends RadViewComponent> nodes, boolean vertical) {
        ArrayList<ViewData> reachable = new ArrayList<ViewData>();
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        for (RadViewComponent radViewComponent : nodes) {
            ViewData view = this.myNodeToView.get((Object)radViewComponent);
            if (view == null) continue;
            this.findBackwards(view, visiting, reachable, vertical, view);
        }
        HashSet<RadViewComponent> dependents = new HashSet<RadViewComponent>(reachable.size());
        for (ViewData v : reachable) {
            dependents.add(v.node);
        }
        return dependents;
    }

    private void findBackwards(ViewData view, Set<ViewData> visiting, List<ViewData> reachable, boolean vertical, ViewData start) {
        visiting.add(view);
        reachable.add(view);
        for (Constraint constraint : view.dependedOnBy) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            assert (constraint.to == view);
            ViewData from = constraint.from;
            if (visiting.contains(from)) {
                List<Constraint> path = this.getPathTo(start.node, view.node, vertical);
                if (path == null) continue;
            }
            this.findBackwards(from, visiting, reachable, vertical, start);
        }
        visiting.remove(view);
    }

    @Nullable
    public List<Constraint> getPathTo(RadViewComponent from, RadViewComponent to, boolean vertical) {
        HashSet<ViewData> visiting = new HashSet<ViewData>();
        ArrayList<Constraint> path = new ArrayList<Constraint>();
        ViewData view = this.myNodeToView.get((Object)from);
        if (view != null) {
            return DependencyGraph.findForwards(view, visiting, path, vertical, to);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static List<Constraint> findForwards(ViewData view, Set<ViewData> visiting, List<Constraint> path, boolean vertical, RadViewComponent target) {
        visiting.add(view);
        for (Constraint constraint : view.dependsOn) {
            if (vertical && !constraint.type.verticalEdge || !vertical && !constraint.type.horizontalEdge) continue;
            try {
                List<Constraint> chain;
                path.add(constraint);
                if (constraint.to.node == target) {
                    ArrayList<Constraint> arrayList = new ArrayList<Constraint>(path);
                    return arrayList;
                }
                assert (constraint.from == view);
                ViewData to = constraint.to;
                if (visiting.contains(to) || (chain = DependencyGraph.findForwards(to, visiting, path, vertical, target)) == null) continue;
                List<Constraint> list = chain;
                return list;
            }
            finally {
                path.remove(constraint);
            }
        }
        visiting.remove(view);
        return null;
    }

    static class Constraint {
        @NotNull
        public final ConstraintType type;
        public final ViewData from;
        public final ViewData to;

        Constraint(@NotNull ConstraintType type, @NotNull ViewData from, @NotNull ViewData to) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/android/designer/model/layout/relative/DependencyGraph$Constraint", "<init>"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/android/designer/model/layout/relative/DependencyGraph$Constraint", "<init>"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/android/designer/model/layout/relative/DependencyGraph$Constraint", "<init>"));
            }
            this.type = type;
            this.from = from;
            this.to = to;
        }

        static String describePath(@NotNull List<Constraint> path, @Nullable String newName, @Nullable String newId) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/android/designer/model/layout/relative/DependencyGraph$Constraint", "describePath"));
            }
            String s = "";
            for (int i = path.size() - 1; i >= 0; --i) {
                Constraint constraint = path.get(i);
                String suffix = i == path.size() - 1 ? constraint.to.id : s;
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, constraint.from.id, Constraint.stripLayoutAttributePrefix(constraint.type.name), suffix);
            }
            if (newName != null) {
                s = String.format(DependencyGraph.DEPENDENCY_FORMAT, s, Constraint.stripLayoutAttributePrefix(newName), newId != null ? LintUtils.stripIdPrefix((String)newId) : "?");
            }
            return s;
        }

        private static String stripLayoutAttributePrefix(String name) {
            if (name.startsWith("layout_")) {
                return name.substring("layout_".length());
            }
            return name;
        }
    }

    static class ViewData {
        @NotNull
        public final RadViewComponent node;
        @Nullable
        public final String id;
        @NotNull
        public final List<Constraint> dependsOn;
        @NotNull
        public final List<Constraint> dependedOnBy;

        ViewData(@NotNull RadViewComponent node, @Nullable String id) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/android/designer/model/layout/relative/DependencyGraph$ViewData", "<init>"));
            }
            this.dependsOn = new ArrayList<Constraint>(4);
            this.dependedOnBy = new ArrayList<Constraint>(8);
            this.node = node;
            this.id = id;
        }
    }
}

