/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.morphing;

import com.intellij.android.designer.model.ComponentMorphingTool;
import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.android.designer.model.grid.GridInfo;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableLayout;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class GridLayout {
    public static RadViewComponent TableLayout(RadViewComponent component, MetaModel target) throws Exception {
        final List[][] components = GridLayout.getGridComponents((RadGridLayoutComponent)component);
        final MetaModel tableRowModel = ViewsMetaManager.getInstance(component.getTag().getProject()).getModelByTag("TableRow");
        return new ComponentMorphingTool(component, new RadTableLayoutComponent(), target, new RadTableLayout()){

            @Override
            protected void convertChildren() throws Exception {
                for (List[] rowComponents : components) {
                    RadViewComponent newRowComponent = RadComponentOperations.createComponent(null, tableRowModel);
                    RadComponentOperations.addComponent(this.myNewComponent, newRowComponent, null);
                    for (List cellComponents : rowComponents) {
                        if (cellComponents == null) continue;
                        for (RadComponent cellComponent : cellComponents) {
                            RadComponentOperations.moveComponent(newRowComponent, (RadViewComponent)cellComponent, null);
                        }
                    }
                }
            }

            @Override
            protected void convertTag() {
                XmlTag tag = this.myNewComponent.getTag();
                RadComponentOperations.deleteAttribute(tag, "rowCount");
                RadComponentOperations.deleteAttribute(tag, "columnCount");
                for (RadComponent rowComponent : this.myNewComponent.getChildren()) {
                    for (RadComponent cellComponent : rowComponent.getChildren()) {
                        XmlTag cellTag = ((RadViewComponent)cellComponent).getTag();
                        RadComponentOperations.deleteAttribute(cellTag, "layout_row");
                        RadComponentOperations.deleteAttribute(cellTag, "layout_rowSpan");
                        XmlAttribute attribute = cellTag.getAttribute("layout_columnSpan", "http://schemas.android.com/apk/res/android");
                        if (attribute == null) continue;
                        attribute.setName(attribute.getNamespacePrefix() + ":layout_span");
                    }
                }
            }

            @Override
            protected void loadChildProperties(PropertyParser propertyParser) throws Exception {
            }
        }.result();
    }

    private static List<RadComponent>[][] getGridComponents(RadGridLayoutComponent parent) {
        GridInfo gridInfo = parent.getGridInfo();
        List[][] components = new List[gridInfo.rowCount][gridInfo.columnCount];
        for (RadComponent child : parent.getChildren()) {
            Rectangle cellInfo = RadGridLayoutComponent.getCellInfo(child);
            ArrayList<RadComponent> cellComponents = components[cellInfo.y][cellInfo.x];
            if (cellComponents == null) {
                components[cellInfo.y][cellInfo.x] = cellComponents = new ArrayList<RadComponent>();
            }
            cellComponents.add(child);
        }
        return components;
    }
}

