/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.morphing;

import com.intellij.android.designer.model.ComponentMorphingTool;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.layout.RadLinearLayout;
import com.intellij.android.designer.model.layout.RadRadioGroupLayout;
import com.intellij.android.designer.model.layout.grid.RadGridLayout;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.android.designer.model.morphing.LinearLayout;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;

public class RadioGroup {
    public static RadViewComponent LinearLayout(RadViewComponent component, MetaModel target) throws Exception {
        return RadioGroup.convert(component, component, target, new RadLinearLayout());
    }

    public static RadViewComponent GridLayout(RadViewComponent component, MetaModel target) throws Exception {
        return RadioGroup.convert(component, new RadGridLayoutComponent(), target, new RadGridLayout());
    }

    private static RadViewComponent convert(RadViewComponent oldComponent, RadViewComponent newComponent, MetaModel target, RadLayout layout) throws Exception {
        final boolean horizontal = ((RadRadioGroupLayout)oldComponent.getLayout()).isHorizontal();
        return new ComponentMorphingTool(oldComponent, newComponent, target, layout){

            @Override
            protected void convertTag() {
                if (horizontal) {
                    RadComponentOperations.deleteAttribute((RadComponent)this.myNewComponent, "orientation");
                } else {
                    this.myNewComponent.getTag().setAttribute("orientation", "http://schemas.android.com/apk/res/android", "vertical");
                }
            }
        }.result();
    }

    public static RadViewComponent TableLayout(RadViewComponent component, MetaModel target) throws Exception {
        boolean horizontal = ((RadRadioGroupLayout)component.getLayout()).isHorizontal();
        return LinearLayout.TableLayout(component, target, horizontal);
    }
}

