/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable;

import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.propertyTable.FlagProperty;
import com.intellij.android.designer.propertyTable.editors.StringsComboEditor;
import com.intellij.designer.model.Property;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravityProperty
extends FlagProperty {
    private static final String[] CENTER = new String[]{"center_horizontal", "center_vertical", "center"};
    private static final String[] FILL = new String[]{"fill_horizontal", "fill_vertical", "fill"};
    private static final String[] CLIP = new String[]{"clip_horizontal", "clip_vertical"};
    private static final String[] COMBO_ITEMS = new String[]{"horizontal", "vertical", "both"};

    public GravityProperty(@NotNull String name, @NotNull AttributeDefinition definition) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/GravityProperty", "<init>"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/android/designer/propertyTable/GravityProperty", "<init>"));
        }
        super(name, definition);
        this.myOptions.remove(this.getProperty("center_horizontal"));
        this.myOptions.remove(this.getProperty("center_vertical"));
        this.myOptions.set(this.getProperty("center"), new ComboOptionProperty(this, "center", CENTER){

            @Override
            protected void setValue(RadViewComponent component, int index) throws Exception {
                if (index == 0) {
                    GravityProperty.this.setOptions(component, new String[]{"center_horizontal"}, new String[]{"center_vertical", "center"});
                } else if (index == 1) {
                    GravityProperty.this.setOptions(component, new String[]{"center_vertical"}, new String[]{"center_horizontal", "center"});
                } else {
                    GravityProperty.this.setOptions(component, new String[]{"center"}, new String[]{"center_horizontal", "center_vertical"});
                }
            }
        });
        this.myOptions.remove(this.getProperty("fill_horizontal"));
        this.myOptions.remove(this.getProperty("fill_vertical"));
        this.myOptions.set(this.getProperty("fill"), new ComboOptionProperty(this, "fill", FILL){

            @Override
            protected void setValue(RadViewComponent component, int index) throws Exception {
                if (index == 0) {
                    GravityProperty.this.setOptions(component, new String[]{"fill_horizontal"}, new String[]{"fill_vertical", "fill"});
                } else if (index == 1) {
                    GravityProperty.this.setOptions(component, new String[]{"fill_vertical"}, new String[]{"fill_horizontal", "fill"});
                } else {
                    GravityProperty.this.setOptions(component, new String[]{"fill"}, new String[]{"fill_horizontal", "fill_vertical"});
                }
            }
        });
        int clip_vertical = this.getProperty("clip_vertical");
        if (clip_vertical != -1) {
            this.myOptions.remove(clip_vertical);
            this.myOptions.set(this.getProperty("clip_horizontal"), new ComboOptionProperty(this, "clip", CLIP){

                @Override
                protected void setValue(RadViewComponent component, int index) throws Exception {
                    if (index == 0) {
                        GravityProperty.this.setOptions(component, new String[]{"clip_horizontal"}, new String[]{"clip_vertical"});
                    } else if (index == 1) {
                        GravityProperty.this.setOptions(component, new String[]{"clip_vertical"}, new String[]{"clip_horizontal"});
                    } else {
                        GravityProperty.this.setOptions(component, CLIP, null);
                    }
                }
            });
        }
    }

    private int getProperty(String name) {
        int size = this.myOptions.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equals(((Property)this.myOptions.get(i)).getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getValue(@NotNull RadViewComponent component) throws Exception {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/GravityProperty", "getValue"));
        }
        StringBuilder value = new StringBuilder("[");
        Set<String> options = this.getOptions(component);
        int index = 0;
        for (Property option : this.myOptions) {
            String name = null;
            if (option instanceof FlagProperty.OptionProperty) {
                if (options.contains(((FlagProperty.OptionProperty)option).getValueName())) {
                    name = option.getName();
                }
            } else {
                name = ((ComboOptionProperty)option).getValue(options);
            }
            if (name == null) continue;
            if (index++ > 0) {
                value.append(", ");
            }
            value.append(name);
        }
        return value.append("]").toString();
    }

    private void setOptions(final RadViewComponent component, @Nullable String[] setNames, @Nullable String[] unsetNames) throws Exception {
        final HashSet<String> options = new HashSet<String>(this.getOptions(component));
        if (unsetNames != null) {
            for (String name : unsetNames) {
                options.remove(name);
            }
        }
        if (setNames != null) {
            Collections.addAll(options, setNames);
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (options.isEmpty()) {
                    XmlAttribute attribute = GravityProperty.this.getAttribute(component);
                    if (attribute != null) {
                        attribute.delete();
                    }
                } else {
                    component.getTag().setAttribute(GravityProperty.this.myDefinition.getName(), GravityProperty.this.getNamespace(component, true), StringUtil.join((Collection)options, (String)"|"));
                }
            }
        });
    }

    private abstract class ComboOptionProperty
    extends Property<RadViewComponent> {
        private final PropertyRenderer myRenderer;
        private final PropertyEditor myEditor;
        private final String[] myValues;

        public ComboOptionProperty(@NotNull Property parent, String name, String[] values) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/GravityProperty$ComboOptionProperty", "<init>"));
            }
            super(parent, name);
            this.myRenderer = new LabelPropertyRenderer(null);
            this.myEditor = new StringsComboEditor(COMBO_ITEMS);
            this.myValues = values;
        }

        @Nullable
        public String getValue(Set<String> options) {
            StringBuilder values = new StringBuilder();
            int index = 0;
            for (String value : this.myValues) {
                if (!options.contains(value)) continue;
                if (index++ > 0) {
                    values.append(", ");
                }
                values.append(value);
            }
            return index == 0 ? null : values.toString();
        }

        public Object getValue(@NotNull RadViewComponent component) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/GravityProperty$ComboOptionProperty", "getValue"));
            }
            Set<String> options = GravityProperty.this.getOptions(component);
            int lastIndex = -1;
            for (int i = 0; i < this.myValues.length; ++i) {
                if (!options.contains(this.myValues[i])) continue;
                lastIndex = i;
            }
            return lastIndex == -1 ? null : COMBO_ITEMS[lastIndex];
        }

        public void setValue(@NotNull RadViewComponent component, Object value) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/GravityProperty$ComboOptionProperty", "setValue"));
            }
            int index = ArrayUtil.indexOf((Object[])COMBO_ITEMS, (Object)value);
            if (index == -1) {
                GravityProperty.this.setOptions(component, null, this.myValues);
            } else {
                this.setValue(component, index);
            }
        }

        protected abstract void setValue(RadViewComponent var1, int var2) throws Exception;

        public boolean isDefaultValue(@NotNull RadViewComponent component) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/GravityProperty$ComboOptionProperty", "isDefaultValue"));
            }
            Set<String> options = GravityProperty.this.getOptions(component);
            for (String value : this.myValues) {
                if (!options.contains(value)) continue;
                return false;
            }
            return true;
        }

        public void setDefaultValue(@NotNull RadViewComponent component) throws Exception {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/propertyTable/GravityProperty$ComboOptionProperty", "setDefaultValue"));
            }
            this.setValue(component, null);
        }

        public Property<RadViewComponent> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/android/designer/propertyTable/GravityProperty$ComboOptionProperty", "createForNewPresentation"));
            }
            return null;
        }

        @NotNull
        public PropertyRenderer getRenderer() {
            PropertyRenderer propertyRenderer = this.myRenderer;
            if (propertyRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/GravityProperty$ComboOptionProperty", "getRenderer"));
            }
            return propertyRenderer;
        }

        public PropertyEditor getEditor() {
            return this.myEditor;
        }

        public boolean needRefreshPropertyList() {
            return true;
        }
    }
}

