/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.artifact;

import com.intellij.facet.FacetModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.compiler.artifact.AndroidApplicationArtifactProperties;
import org.jetbrains.android.compiler.artifact.AndroidArtifactPropertiesProvider;
import org.jetbrains.android.compiler.artifact.AndroidArtifactUtil;
import org.jetbrains.android.compiler.artifact.AndroidFinalPackageElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationArtifactType
extends ArtifactType {
    public AndroidApplicationArtifactType() {
        super("apk", "Android Application");
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Artifact;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "getIcon"));
        }
        return icon;
    }

    public String getDefaultPathFor(@NotNull PackagingElementOutputKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "getDefaultPathFor"));
        }
        return "/";
    }

    public boolean isSuitableItem(@NotNull PackagingSourceItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "isSuitableItem"));
        }
        return !(item instanceof ModuleOutputSourceItem) && !(item instanceof LibrarySourceItem);
    }

    @NotNull
    public CompositePackagingElement<?> createRootElement(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "createRootElement"));
        }
        CompositePackagingElement compositePackagingElement = PackagingElementFactory.getInstance().createArchive(ArtifactUtil.suggestArtifactFileName((String)artifactName) + ".apk");
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "createRootElement"));
        }
        return compositePackagingElement;
    }

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "getNewArtifactTemplates"));
        }
        ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
        for (Module module : context.getModulesProvider().getModules()) {
            FacetModel facetModel = context.getModulesProvider().getFacetModel(module);
            AndroidFacet facet = (AndroidFacet)facetModel.getFacetByType(AndroidFacet.ID);
            if (facet == null || facet.isLibraryProject()) continue;
            facets.add(facet);
        }
        if (facets.size() == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "getNewArtifactTemplates"));
            }
            return list;
        }
        List<MyTemplate> list = Collections.singletonList(new MyTemplate(context.getProject(), facets));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType", "getNewArtifactTemplates"));
        }
        return list;
    }

    public static ArtifactType getInstance() {
        return (ArtifactType)ContainerUtil.findInstance((Object[])AndroidApplicationArtifactType.getAllTypes(), AndroidApplicationArtifactType.class);
    }

    private class MyTemplate
    extends ArtifactTemplate {
        private final Project myProject;
        private final List<AndroidFacet> myFacets;

        private MyTemplate(@NotNull Project project, List<AndroidFacet> facets) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType$MyTemplate", "<init>"));
            }
            if (facets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facets", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType$MyTemplate", "<init>"));
            }
            assert (facets.size() > 0);
            this.myProject = project;
            this.myFacets = facets;
        }

        public String getPresentableName() {
            return this.myFacets.size() == 1 ? "From module '" + this.myFacets.get(0).getModule().getName() + "'" : "From module...";
        }

        public ArtifactTemplate.NewArtifactConfiguration createArtifact() {
            AndroidFacet facet;
            AndroidFacet androidFacet = facet = this.myFacets.size() == 1 ? this.myFacets.get(0) : AndroidArtifactUtil.chooseAndroidApplicationModule(this.myProject, this.myFacets);
            if (facet == null) {
                return null;
            }
            CompositePackagingElement<?> rootElement = AndroidApplicationArtifactType.this.createRootElement(facet.getModule().getName());
            rootElement.addFirstChild((PackagingElement)new AndroidFinalPackageElement(this.myProject, facet));
            return new ArtifactTemplate.NewArtifactConfiguration(rootElement, facet.getModule().getName(), (ArtifactType)AndroidApplicationArtifactType.this);
        }

        public void setUpArtifact(@NotNull Artifact artifact, @NotNull ArtifactTemplate.NewArtifactConfiguration configuration) {
            ArtifactProperties properties;
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType$MyTemplate", "setUpArtifact"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/android/compiler/artifact/AndroidApplicationArtifactType$MyTemplate", "setUpArtifact"));
            }
            AndroidFacet facet = AndroidArtifactUtil.getPackagedFacet(this.myProject, artifact);
            if (facet != null && (properties = artifact.getProperties((ArtifactPropertiesProvider)AndroidArtifactPropertiesProvider.getInstance())) instanceof AndroidApplicationArtifactProperties) {
                AndroidApplicationArtifactProperties p = (AndroidApplicationArtifactProperties)properties;
                p.setProGuardCfgFiles(facet.getProperties().myProGuardCfgFiles);
            }
        }
    }
}

