/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import javax.swing.Icon;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SetAttributeQuickFix
implements AndroidLintQuickFix {
    private final String myName;
    private final String myAttributeName;
    private final String myValue;

    SetAttributeQuickFix(@NotNull String name, @NotNull String attributeName, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "<init>"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "<init>"));
        }
        this.myName = name;
        this.myAttributeName = attributeName;
        this.myValue = value;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "getName"));
        }
        return string;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "apply"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "apply"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "apply"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return;
        }
        String value = this.myValue;
        if (value == null && context instanceof AndroidQuickfixContexts.DesignerContext && (value = this.askForAttributeValue((PsiElement)tag)) == null) {
            return;
        }
        XmlAttribute attribute = tag.setAttribute(this.myAttributeName, "http://schemas.android.com/apk/res/android", "");
        if (attribute != null) {
            if (value != null) {
                attribute.setValue(value);
            }
            if (context instanceof AndroidQuickfixContexts.EditorContext) {
                Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                XmlAttributeValue valueElement = attribute.getValueElement();
                TextRange valueTextRange = attribute.getValueTextRange();
                if (valueElement != null && valueTextRange != null) {
                    int valueElementStart = valueElement.getTextRange().getStartOffset();
                    editor.getCaretModel().moveToOffset(valueElementStart + valueTextRange.getStartOffset());
                    if (valueTextRange.getStartOffset() < valueTextRange.getEndOffset()) {
                        editor.getSelectionModel().setSelection(valueElementStart + valueTextRange.getStartOffset(), valueElementStart + valueTextRange.getEndOffset());
                    }
                }
            }
        }
    }

    @Nullable
    private String askForAttributeValue(@NotNull PsiElement context) {
        String[] variants;
        AttributeDefinition def;
        AttributeDefinitions attrDefs;
        SystemResourceManager srm;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "askForAttributeValue"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(context);
        String message = "Specify value of attribute '" + this.myAttributeName + "'";
        String title = "Set Attribute Value";
        if (facet != null && (srm = facet.getSystemResourceManager()) != null && (attrDefs = srm.getAttributeDefinitions()) != null && (def = attrDefs.getAttrDefByName(this.myAttributeName)) != null && (variants = def.getValues()).length > 0) {
            return Messages.showEditableChooseDialog((String)message, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
        }
        return Messages.showInputDialog((Project)context.getProject(), (String)message, (String)"Set Attribute Value", (Icon)Messages.getQuestionIcon());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "isApplicable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "isApplicable"));
        }
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "org/jetbrains/android/inspections/lint/SetAttributeQuickFix", "isApplicable"));
        }
        if (this.myValue == null && contextType == AndroidQuickfixContexts.BatchContext.TYPE) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        return tag.getAttribute(this.myAttributeName, "http://schemas.android.com/apk/res/android") == null;
    }
}

