/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Producer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;

public class ChooseFileIntentionAction
implements IntentionAction {
    private Producer<VirtualFile[]> myFileChooser = null;

    @NotNull
    public String getFamilyName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = MavenDomBundle.message("intention.choose.file", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction", "getText"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction", "isAvailable"));
        }
        if (!MavenDomUtil.isMavenFile(file)) {
            return false;
        }
        MavenDomDependency dep = ChooseFileIntentionAction.getDependency(file, editor);
        return dep != null && "system".equals(dep.getScope().getStringValue());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        VirtualFile[] files;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction", "invoke"));
        }
        final MavenDomDependency dep = ChooseFileIntentionAction.getDependency(file, editor);
        if (this.myFileChooser == null) {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, false);
            PsiFile currentValue = dep != null ? (PsiFile)dep.getSystemPath().getValue() : null;
            VirtualFile toSelect = currentValue == null ? null : currentValue.getVirtualFile();
            files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect);
        } else {
            files = (VirtualFile[])this.myFileChooser.produce();
        }
        if (files == null || files.length == 0) {
            return;
        }
        final PsiFile selectedFile = PsiManager.getInstance((Project)project).findFile(files[0]);
        if (selectedFile == null) {
            return;
        }
        if (dep != null) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction$1", "run"));
                    }
                    dep.getSystemPath().setValue((Object)selectedFile);
                }
            }.execute();
        }
    }

    public void setFileChooser(@Nullable Producer<VirtualFile[]> fileChooser) {
        this.myFileChooser = fileChooser;
    }

    @Nullable
    private static MavenDomDependency getDependency(PsiFile file, Editor editor) {
        PsiElement el = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)el, XmlTag.class, (boolean)false);
        if (tag == null) {
            return null;
        }
        DomElement dom = DomManager.getDomManager((Project)el.getProject()).getDomElement(tag);
        if (dom == null) {
            return null;
        }
        return (MavenDomDependency)dom.getParentOfType(MavenDomDependency.class, false);
    }
}

