/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.introduce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.StringLenComparator;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.ComboBoxUtil;

public class IntroducePropertyDialog
extends DialogWrapper {
    private final Project myProject;
    private final XmlElement myContext;
    private final MavenDomProjectModel myMavenDomProjectModel;
    private final String mySelectedString;
    private NameSuggestionsField myNameField;
    private NameSuggestionsField.DataChanged myNameChangedListener;
    private JComboBox myMavenProjectsComboBox;
    private JPanel myMainPanel;
    private JPanel myFieldNamePanel;

    public IntroducePropertyDialog(@NotNull Project project, @NotNull XmlElement context, @NotNull MavenDomProjectModel mavenDomProjectModel, @NotNull String selectedString) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "<init>"));
        }
        if (mavenDomProjectModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenDomProjectModel", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "<init>"));
        }
        if (selectedString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedString", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myContext = context;
        this.myMavenDomProjectModel = mavenDomProjectModel;
        this.mySelectedString = selectedString;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(MavenDomBundle.message("refactoring.introduce.property", objectArray));
        this.init();
    }

    protected void dispose() {
        this.myNameField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "createActions"));
        }
        return actionArray;
    }

    protected void init() {
        super.init();
        this.updateOkStatus();
    }

    public String getEnteredName() {
        return this.myNameField.getEnteredName().trim();
    }

    @NotNull
    public MavenDomProjectModel getSelectedProject() {
        MavenDomProjectModel selectedItem = (MavenDomProjectModel)ComboBoxUtil.getSelectedValue((DefaultComboBoxModel)this.myMavenProjectsComboBox.getModel());
        MavenDomProjectModel mavenDomProjectModel = selectedItem == null ? this.myMavenDomProjectModel : selectedItem;
        if (mavenDomProjectModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "getSelectedProject"));
        }
        return mavenDomProjectModel;
    }

    private String[] getSuggestions() {
        return this.getSuggestions(1);
    }

    private String[] getSuggestions(int level) {
        String newValue;
        Object result = new THashSet();
        String value = this.mySelectedString.trim();
        boolean addUnqualifiedForm = true;
        XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, XmlTag.class, (boolean)false);
        DomElement domParent = DomUtil.getDomElement((PsiElement)parent);
        if (domParent != null) {
            DomElement domSuperParent = domParent.getParent();
            DomFileElement domFile = DomUtil.getFileElement((DomElement)domParent);
            if (domSuperParent != null && domFile != null && domFile.getRootElement() == domSuperParent) {
                value = domSuperParent.getXmlElementName();
                addUnqualifiedForm = false;
            } else {
                String artifactId;
                MavenDomShortArtifactCoordinates coordinates = (MavenDomShortArtifactCoordinates)DomUtil.getParentOfType((DomElement)domParent, MavenDomShortArtifactCoordinates.class, (boolean)false);
                if (coordinates != null && !(coordinates instanceof MavenDomProjectModel) && domParent != coordinates.getArtifactId() && !StringUtil.isEmptyOrSpaces((String)(artifactId = coordinates.getArtifactId().getStringValue()))) {
                    value = artifactId;
                    addUnqualifiedForm = false;
                }
            }
        }
        while (!(newValue = value.replaceAll("  ", " ")).equals(value)) {
            value = newValue;
        }
        value = value.replaceAll(" ", ".");
        List parts = StringUtil.split((String)value, (String)".");
        String shortValue = (String)parts.get(parts.size() - 1);
        if (addUnqualifiedForm) {
            result.add(value);
            result.add(shortValue);
        }
        String suffix = "";
        while (parent != null && level != 0) {
            suffix = parent.getName() + suffix;
            result.add(suffix);
            result.add(value + "." + suffix);
            result.add(shortValue + "." + suffix);
            suffix = "." + suffix;
            parent = parent.getParentTag();
            --level;
        }
        result = new ArrayList(result);
        Collections.sort((List)result, CodeStyleSettingsManager.getSettings((Project)this.myProject).PREFER_LONGER_NAMES ? StringLenComparator.getDescendingInstance() : StringLenComparator.getInstance());
        return ArrayUtil.toStringArray((Collection)result);
    }

    private static String joinWords(@NotNull String s, @NotNull String delimiter) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "joinWords"));
        }
        if (delimiter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delimiter", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "joinWords"));
        }
        return IntroducePropertyDialog.joinWords(StringUtil.split((String)s, (String)delimiter));
    }

    private static String joinWords(@NotNull List<String> stringList) {
        if (stringList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringList", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "joinWords"));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stringList.size(); ++i) {
            String word = stringList.get(i);
            if (StringUtil.isEmptyOrSpaces((String)word)) continue;
            sb.append(i == 0 ? StringUtil.decapitalize((String)word.trim()) : StringUtil.capitalize((String)word.trim()));
        }
        return sb.toString();
    }

    protected JComponent createCenterPanel() {
        this.myFieldNamePanel.setLayout(new BorderLayout());
        this.myNameField = new NameSuggestionsField(this.myProject);
        this.myNameChangedListener = new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                IntroducePropertyDialog.this.updateOkStatus();
            }
        };
        this.myNameField.addDataChangedListener(this.myNameChangedListener);
        this.myNameField.setSuggestions(this.getSuggestions());
        this.myFieldNamePanel.add((Component)this.myNameField, "Center");
        List<MavenDomProjectModel> projects = this.getProjects();
        ComboBoxUtil.setModel(this.myMavenProjectsComboBox, new DefaultComboBoxModel(), projects, new Function<MavenDomProjectModel, Pair<String, ?>>(){

            public Pair<String, ?> fun(MavenDomProjectModel model) {
                String projectName = model.getName().getStringValue();
                MavenProject mavenProject = MavenDomUtil.findProject(model);
                if (mavenProject != null) {
                    projectName = mavenProject.getDisplayName();
                }
                if (StringUtil.isEmptyOrSpaces((String)projectName)) {
                    projectName = "pom.xml";
                }
                return Pair.create((Object)projectName, (Object)model);
            }
        });
        this.myMavenProjectsComboBox.setSelectedItem(this.myMavenDomProjectModel);
        return this.myMainPanel;
    }

    private List<MavenDomProjectModel> getProjects() {
        ArrayList<MavenDomProjectModel> projects = new ArrayList<MavenDomProjectModel>();
        projects.add(this.myMavenDomProjectModel);
        projects.addAll(MavenDomProjectProcessorUtils.collectParentProjects(this.myMavenDomProjectModel));
        return projects;
    }

    private void updateOkStatus() {
        String text = this.getEnteredName();
        this.setOKActionEnabled(!StringUtil.isEmptyOrSpaces((String)text) && !IntroducePropertyDialog.isContainWrongSymbols(text) && !this.isPropertyExist(text));
    }

    private static boolean isContainWrongSymbols(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "isContainWrongSymbols"));
        }
        return text.length() == 0 || Character.isDigit(text.charAt(0)) || StringUtil.containsAnyChar((String)text, (String)"\t ;*'\"\\/,()^&<>={}[]");
    }

    private boolean isPropertyExist(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyDialog", "isPropertyExist"));
        }
        MavenDomProjectModel project = this.getSelectedProject();
        if (IntroducePropertyDialog.isPropertyExist(text, project)) {
            return true;
        }
        for (MavenDomProjectModel child : MavenDomProjectProcessorUtils.getChildrenProjects(project)) {
            if (!IntroducePropertyDialog.isPropertyExist(text, child)) continue;
            return true;
        }
        for (MavenDomProjectModel parent : MavenDomProjectProcessorUtils.collectParentProjects(project)) {
            if (!IntroducePropertyDialog.isPropertyExist(text, parent)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPropertyExist(String propertyName, MavenDomProjectModel project) {
        MavenDomProperties props = project.getProperties();
        XmlTag propsTag = props.getXmlTag();
        if (propsTag != null) {
            for (XmlTag each : propsTag.getSubTags()) {
                if (!propertyName.equals(each.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Project");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Name");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFieldNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMavenProjectsComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

