/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.references.MavenContextlessPropertyReference;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.plugins.api.MavenPluginParamInfo;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenPropertyPsiReferenceProvider
extends PsiReferenceProvider {
    public static final boolean SOFT_DEFAULT = false;

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = MavenPropertyPsiReferenceProvider.getReferences(element, false);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static boolean isElementCanContainReference(PsiElement element) {
        if (element instanceof XmlTag) {
            for (MavenPluginParamInfo.ParamInfo info : MavenPluginParamInfo.getParamInfoList((XmlTag)element)) {
                if (!Boolean.TRUE.equals(info.getParam().disableReferences)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static MavenProject findMavenProject(PsiElement element) {
        VirtualFile virtualFile = MavenDomUtil.getVirtualFile(element);
        if (virtualFile == null) {
            return null;
        }
        MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
        return manager.findProject(virtualFile);
    }

    public static PsiReference[] getReferences(PsiElement element, boolean isSoft) {
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        if (textRange.isEmpty()) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = element.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!MavenPropertyPsiReferenceProvider.isElementCanContainReference(element)) {
            return PsiReference.EMPTY_ARRAY;
        }
        MavenProject mavenProject = null;
        XmlTag propertiesTag = null;
        ArrayList<MavenContextlessPropertyReference> result = null;
        Matcher matcher = MavenPropertyResolver.PATTERN.matcher(textRange.substring(text));
        while (matcher.find()) {
            int from;
            String propertyName = matcher.group(1);
            if (propertyName == null) {
                propertyName = matcher.group(2);
                from = matcher.start(2);
            } else {
                from = matcher.start(1);
            }
            TextRange range = TextRange.from((int)(textRange.getStartOffset() + from), (int)propertyName.length());
            if (result == null) {
                result = new ArrayList<MavenContextlessPropertyReference>();
                mavenProject = MavenPropertyPsiReferenceProvider.findMavenProject(element);
                if (mavenProject == null && (propertiesTag = MavenPropertyPsiReferenceProvider.findPropertiesParentTag(element)) == null) {
                    return PsiReference.EMPTY_ARRAY;
                }
            }
            Object ref = mavenProject != null ? new MavenPropertyPsiReference(mavenProject, element, propertyName, range, isSoft) : new MavenContextlessPropertyReference(propertiesTag, element, range, true);
            result.add((MavenContextlessPropertyReference)((Object)ref));
        }
        return result == null ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
    }

    private static XmlTag findPropertiesParentTag(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/references/MavenPropertyPsiReferenceProvider", "findPropertiesParentTag"));
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)element);
        return domElement instanceof MavenDomProperties ? domElement.getXmlTag() : null;
    }
}

