/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionContributor {
    private final MultiMap<CompletionType, Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>>> myMap = new MultiMap();

    public final void extend(@Nullable CompletionType type, @NotNull ElementPattern<? extends PsiElement> place, CompletionProvider<CompletionParameters> provider) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/completion/CompletionContributor", "extend"));
        }
        this.myMap.putValue((Object)type, (Object)new Pair(place, provider));
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        ProcessingContext context;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/CompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/CompletionContributor", "fillCompletionVariants"));
        }
        for (Pair pair : this.myMap.get((Object)parameters.getCompletionType())) {
            context = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters.getPosition(), context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result);
            if (!result.isStopped()) continue;
            return;
        }
        for (Pair pair : this.myMap.get(null)) {
            context = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(parameters.getPosition(), context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result);
            if (!result.isStopped()) continue;
            return;
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/CompletionContributor", "beforeCompletion"));
        }
    }

    @Nullable
    public String advertise(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/CompletionContributor", "advertise"));
        }
        return null;
    }

    @Nullable
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/CompletionContributor", "handleEmptyLookup"));
        }
        return null;
    }

    @Nullable
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/CompletionContributor", "handleAutoCompletionPossibility"));
        }
        return null;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/CompletionContributor", "invokeAutoPopup"));
        }
        return false;
    }

    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/CompletionContributor", "duringCompletion"));
        }
    }

    @NotNull
    protected static String getActionShortcut(@NonNls @NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/codeInsight/completion/CompletionContributor", "getActionShortcut"));
        }
        String string = KeymapUtil.getFirstKeyboardShortcutText(ActionManager.getInstance().getAction(actionId));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionContributor", "getActionShortcut"));
        }
        return string;
    }

    @NotNull
    public static List<CompletionContributor> forParameters(final @NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/CompletionContributor", "forParameters"));
        }
        List<CompletionContributor> list = ApplicationManager.getApplication().runReadAction(new Computable<List<CompletionContributor>>(){

            public List<CompletionContributor> compute() {
                PsiElement position = parameters.getPosition();
                List<CompletionContributor> all = CompletionContributor.forLanguage(PsiUtilCore.getLanguageAtOffset(position.getContainingFile(), parameters.getOffset()));
                return DumbService.getInstance(position.getProject()).filterByDumbAwareness(all);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionContributor", "forParameters"));
        }
        return list;
    }

    @NotNull
    public static List<CompletionContributor> forLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/completion/CompletionContributor", "forLanguage"));
        }
        List<CompletionContributor> list = MyExtensionPointManager.INSTANCE.forKey(language);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionContributor", "forLanguage"));
        }
        return list;
    }

    private static class MyExtensionPointManager
    extends KeyedExtensionCollector<CompletionContributor, Language> {
        public static final MyExtensionPointManager INSTANCE = new MyExtensionPointManager();

        MyExtensionPointManager() {
            super("com.intellij.completion.contributor");
        }

        @Override
        @NotNull
        protected List<CompletionContributor> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
            if (stringKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringKey", "com/intellij/codeInsight/completion/CompletionContributor$MyExtensionPointManager", "buildExtensions"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/completion/CompletionContributor$MyExtensionPointManager", "buildExtensions"));
            }
            THashSet allowed = new THashSet();
            while (key != null) {
                allowed.add(this.keyToString(key));
                key = key.getBaseLanguage();
            }
            allowed.add("any");
            List<CompletionContributor> list = this.buildExtensions((Set<String>)allowed);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionContributor$MyExtensionPointManager", "buildExtensions"));
            }
            return list;
        }

        @Override
        @NotNull
        protected String keyToString(@NotNull Language key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/completion/CompletionContributor$MyExtensionPointManager", "keyToString"));
            }
            String string = key.getID();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionContributor$MyExtensionPointManager", "keyToString"));
            }
            return string;
        }
    }
}

