/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessOutput {
    private final StringBuilder myStdoutBuilder = new StringBuilder();
    private final StringBuilder myStderrBuilder = new StringBuilder();
    private int myExitCode;
    private boolean myTimeout;
    private boolean myCancelled;

    public ProcessOutput() {
        this.myExitCode = -1;
    }

    public ProcessOutput(int exitCode) {
        this.myExitCode = exitCode;
    }

    public void appendStdout(@Nullable String text) {
        this.myStdoutBuilder.append(text);
    }

    public void appendStderr(@Nullable String text) {
        this.myStderrBuilder.append(text);
    }

    @NotNull
    public String getStdout() {
        String string = this.myStdoutBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessOutput", "getStdout"));
        }
        return string;
    }

    @NotNull
    public String getStderr() {
        String string = this.myStderrBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessOutput", "getStderr"));
        }
        return string;
    }

    @NotNull
    public List<String> getStdoutLines() {
        List<String> list = this.getStdoutLines(true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessOutput", "getStdoutLines"));
        }
        return list;
    }

    @NotNull
    public List<String> getStdoutLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStdout(), excludeEmptyLines);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessOutput", "getStdoutLines"));
        }
        return list;
    }

    @NotNull
    public List<String> getStderrLines() {
        List<String> list = this.getStderrLines(true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessOutput", "getStderrLines"));
        }
        return list;
    }

    @NotNull
    public List<String> getStderrLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStderr(), excludeEmptyLines);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessOutput", "getStderrLines"));
        }
        return list;
    }

    @NotNull
    private static List<String> splitLines(String s, boolean excludeEmptyLines) {
        String converted = StringUtil.convertLineSeparators((String)s);
        List list = StringUtil.split((String)converted, (String)"\n", (boolean)true, (boolean)excludeEmptyLines);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessOutput", "splitLines"));
        }
        return list;
    }

    public boolean checkSuccess(@NotNull Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/execution/process/ProcessOutput", "checkSuccess"));
        }
        if (this.getExitCode() != 0 || this.isTimeout()) {
            logger.info(this.getStderr() + (this.isTimeout() ? "\nTimed out" : "\nExit code " + this.getExitCode()));
            return false;
        }
        return true;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public void setCancelled() {
        this.myCancelled = true;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }
}

