/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Condition;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractTreeBuilder
implements Disposable {
    private AbstractTreeUi myUi;
    @NonNls
    private static final String TREE_BUILDER = "TreeBuilder";
    public static final boolean DEFAULT_UPDATE_INACTIVE = true;
    private final TransferToEDTQueue<Runnable> myLaterInvocator;

    public AbstractTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "<init>"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "<init>"));
        }
        this(tree, treeModel, treeStructure, comparator, true);
    }

    public AbstractTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "<init>"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "<init>"));
        }
        this.myLaterInvocator = new TransferToEDTQueue("Tree later invocator", (Processor)new Processor<Runnable>(){

            public boolean process(Runnable runnable) {
                runnable.run();
                return true;
            }
        }, (Condition)new Condition<Object>(){

            public boolean value(Object o) {
                return AbstractTreeBuilder.this.isDisposed();
            }
        }, 200);
        this.init(tree, treeModel, treeStructure, comparator, updateIfInactive);
    }

    protected AbstractTreeBuilder() {
        this.myLaterInvocator = new TransferToEDTQueue("Tree later invocator", (Processor)new /* invalid duplicate definition of identical inner class */, (Condition)new /* invalid duplicate definition of identical inner class */, 200);
    }

    protected void init(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, AbstractTreeStructure treeStructure, @Nullable Comparator<NodeDescriptor> comparator, boolean updateIfInactive) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "init"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "init"));
        }
        tree.putClientProperty(TREE_BUILDER, new WeakReference<AbstractTreeBuilder>(this));
        this.myUi = this.createUi();
        this.getUi().init(this, tree, treeModel, treeStructure, comparator, updateIfInactive);
        this.setPassthroughMode(AbstractTreeBuilder.isUnitTestingMode());
    }

    @NotNull
    protected AbstractTreeUi createUi() {
        AbstractTreeUi abstractTreeUi = new AbstractTreeUi();
        if (abstractTreeUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "createUi"));
        }
        return abstractTreeUi;
    }

    public final void select(Object element) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(new Object[]{element}, null, false, true);
    }

    public final void select(Object element, @Nullable Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(new Object[]{element}, new UserRunnable(onDone), false, true);
    }

    public final void select(Object element, @Nullable Runnable onDone, boolean addToSelection) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(new Object[]{element}, new UserRunnable(onDone), addToSelection, true);
    }

    public final void select(Object[] elements, @Nullable Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(elements, new UserRunnable(onDone), false, true);
    }

    public final void select(Object[] elements, @Nullable Runnable onDone, boolean addToSelection) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().userSelect(elements, new UserRunnable(onDone), addToSelection, true);
    }

    public final void expand(Object element, @Nullable Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().expand(element, (Runnable)new UserRunnable(onDone));
    }

    public final void expand(Object[] element, @Nullable Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().expand(element, (Runnable)new UserRunnable(onDone));
    }

    public final void collapseChildren(Object element, @Nullable Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().collapseChildren(element, new UserRunnable(onDone));
    }

    @NotNull
    protected AbstractTreeNode createSearchingTreeNodeWrapper() {
        AbstractTreeNodeWrapper abstractTreeNodeWrapper = new AbstractTreeNodeWrapper();
        if (abstractTreeNodeWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "createSearchingTreeNodeWrapper"));
        }
        return abstractTreeNodeWrapper;
    }

    @NotNull
    public final AbstractTreeBuilder setClearOnHideDelay(long clearOnHideDelay) {
        if (this.isDisposed()) {
            AbstractTreeBuilder abstractTreeBuilder = this;
            if (abstractTreeBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "setClearOnHideDelay"));
            }
            return abstractTreeBuilder;
        }
        this.getUi().setClearOnHideDelay(clearOnHideDelay);
        AbstractTreeBuilder abstractTreeBuilder = this;
        if (abstractTreeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "setClearOnHideDelay"));
        }
        return abstractTreeBuilder;
    }

    @Nullable
    protected AbstractTreeUpdater createUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        AbstractTreeUpdater updater = new AbstractTreeUpdater(this);
        updater.setModalityStateComponent(MergingUpdateQueue.ANY_COMPONENT);
        return updater;
    }

    @Nullable
    protected final AbstractTreeUpdater getUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getUpdater();
    }

    public final boolean addSubtreeToUpdateByElement(Object element) {
        if (this.isDisposed()) {
            return false;
        }
        AbstractTreeUpdater updater = this.getUpdater();
        return updater != null && updater.addSubtreeToUpdateByElement(element);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().addSubtreeToUpdate(node);
    }

    public final void addSubtreeToUpdate(DefaultMutableTreeNode node, Runnable afterUpdate) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().addSubtreeToUpdate(node, afterUpdate);
    }

    @Nullable
    public final DefaultMutableTreeNode getRootNode() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getRootNode();
    }

    public final void setNodeDescriptorComparator(Comparator<NodeDescriptor> nodeDescriptorComparator) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().setNodeDescriptorComparator(nodeDescriptorComparator);
    }

    protected Object getTreeStructureElement(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getElement();
    }

    protected void updateNode(DefaultMutableTreeNode node) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().doUpdateNode(node);
    }

    protected boolean validateNode(Object child) {
        return !this.isDisposed() && this.getUi().getTreeStructure().isValid(child);
    }

    protected boolean isDisposeOnCollapsing(NodeDescriptor nodeDescriptor) {
        return true;
    }

    public final JTree getTree() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getTree();
    }

    public final AbstractTreeStructure getTreeStructure() {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getTreeStructure();
    }

    public final void setTreeStructure(@NotNull AbstractTreeStructure structure) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "setTreeStructure"));
        }
        if (this.isDisposed()) {
            return;
        }
        this.getUi().setTreeStructure(structure);
    }

    @Nullable
    public Object getRootElement() {
        AbstractTreeStructure structure = this.getTreeStructure();
        return structure == null ? null : structure.getRootElement();
    }

    public void updateFromRoot() {
        this.queueUpdate();
    }

    public void initRootNode() {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().initRootNode();
    }

    @NotNull
    protected ActionCallback updateFromRootCB() {
        ActionCallback actionCallback = this.queueUpdate();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "updateFromRootCB"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback queueUpdate() {
        ActionCallback actionCallback = this.queueUpdate(true);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "queueUpdate"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback queueUpdate(boolean withStructure) {
        ActionCallback actionCallback = this.queueUpdateFrom(this.getRootElement(), true, withStructure);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "queueUpdate"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback queueUpdateFrom(Object element, boolean forceResort) {
        ActionCallback actionCallback = this.queueUpdateFrom(element, forceResort, true);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "queueUpdateFrom"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback queueUpdateFrom(final Object element, final boolean forceResort, final boolean updateStructure) {
        if (this.getUi() == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "queueUpdateFrom"));
            }
            return actionCallback;
        }
        final ActionCallback result = new ActionCallback();
        this.getUi().invokeLaterIfNeeded(false, new TreeRunnable("AbstractTreeBuilder.queueUpdateFrom"){

            @Override
            public void perform() {
                if (updateStructure && forceResort) {
                    AbstractTreeBuilder.this.getUi().incComparatorStamp();
                }
                AbstractTreeBuilder.this.getUi().queueUpdate(element, updateStructure).notify(result);
            }
        });
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "queueUpdateFrom"));
        }
        return actionCallback;
    }

    public void buildNodeForElement(Object element) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().buildNodeForElement(element);
    }

    @Nullable
    public DefaultMutableTreeNode getNodeForElement(Object element) {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getNodeForElement(element, false);
    }

    public void cleanUp() {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().doCleanUp();
    }

    @Nullable
    protected ProgressIndicator createProgressIndicator() {
        return null;
    }

    protected void expandNodeChildren(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "expandNodeChildren"));
        }
        if (this.isDisposed()) {
            return;
        }
        this.getUi().doExpandNodeChildren(node);
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return !this.isDisposed() && this.getRootElement() == this.getTreeStructureElement(nodeDescriptor);
    }

    protected boolean isAlwaysShowPlus(NodeDescriptor descriptor) {
        return false;
    }

    protected boolean isSmartExpand() {
        return true;
    }

    public final boolean isDisposed() {
        return this.getUi() == null || this.getUi().isReleaseRequested();
    }

    public final void updateSubtree(DefaultMutableTreeNode node) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().updateSubtree(node, true);
    }

    public final boolean wasRootNodeInitialized() {
        return !this.isDisposed() && this.getUi().wasRootNodeInitialized();
    }

    public final boolean isNodeBeingBuilt(TreePath path2) {
        return !this.isDisposed() && this.getUi().isNodeBeingBuilt(path2);
    }

    public final void buildNodeForPath(Object[] path2) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().buildNodeForPath(path2);
    }

    @Nullable
    public final DefaultMutableTreeNode getNodeForPath(Object[] path2) {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().getNodeForPath(path2);
    }

    @Nullable
    protected Object findNodeByElement(Object element) {
        if (this.isDisposed()) {
            return null;
        }
        return this.getUi().findNodeByElement(element);
    }

    public static boolean isLoadingNode(DefaultMutableTreeNode node) {
        return AbstractTreeUi.isLoadingNode(node);
    }

    public boolean isChildrenResortingNeeded(NodeDescriptor descriptor) {
        return true;
    }

    protected void runOnYeildingDone(Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        if (this.myUi.isPassthroughMode() || SwingUtilities.isEventDispatchThread()) {
            onDone.run();
        } else {
            this.myLaterInvocator.offer((Object)onDone);
        }
    }

    protected void yield(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "yield"));
        }
        if (this.isDisposed()) {
            return;
        }
        if (this.myUi.isPassthroughMode()) {
            runnable.run();
        } else {
            this.myLaterInvocator.offer((Object)runnable);
        }
    }

    public boolean isToYieldUpdateFor(DefaultMutableTreeNode node) {
        return true;
    }

    public boolean isToEnsureSelectionOnFocusGained() {
        return true;
    }

    protected void runBackgroundLoading(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "runBackgroundLoading"));
        }
        if (this.isDisposed()) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            app.runReadAction(new TreeRunnable("AbstractTreeBuilder.runBackgroundLoading"){

                @Override
                public void perform() {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    protected void updateAfterLoadedInBackground(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "updateAfterLoadedInBackground"));
        }
        if (this.isDisposed()) {
            return;
        }
        if (this.myUi.isPassthroughMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    @NotNull
    public final ActionCallback getInitialized() {
        if (this.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getInitialized"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.myUi.getInitialized();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getInitialized"));
        }
        return actionCallback;
    }

    @NotNull
    public final ActionCallback getReady(Object requestor) {
        if (this.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getReady"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.myUi.getReady(requestor);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getReady"));
        }
        return actionCallback;
    }

    protected void sortChildren(Comparator<TreeNode> nodeComparator, DefaultMutableTreeNode node, ArrayList<TreeNode> children) {
        Collections.sort(children, nodeComparator);
    }

    public void setPassthroughMode(boolean passthrough) {
        if (this.isDisposed()) {
            return;
        }
        this.myUi.setPassthroughMode(passthrough);
    }

    public void expandAll(@Nullable Runnable onDone) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().expandAll(onDone);
    }

    @NotNull
    public ActionCallback cancelUpdate() {
        if (this.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "cancelUpdate"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.getUi().cancelUpdate();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "cancelUpdate"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback batch(@NotNull Progressive progressive) {
        if (progressive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressive", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "batch"));
        }
        if (this.isDisposed()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "batch"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.getUi().batch(progressive);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "batch"));
        }
        return actionCallback;
    }

    @NotNull
    public AsyncResult<Object> revalidateElement(Object element) {
        if (this.isDisposed()) {
            AsyncResult<Object> asyncResult = AsyncResult.rejected();
            if (asyncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "revalidateElement"));
            }
            return asyncResult;
        }
        AbstractTreeStructure structure = this.getTreeStructure();
        if (structure == null) {
            AsyncResult<Object> asyncResult = AsyncResult.rejected();
            if (asyncResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "revalidateElement"));
            }
            return asyncResult;
        }
        AsyncResult<Object> asyncResult = structure.revalidateElement(element);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "revalidateElement"));
        }
        return asyncResult;
    }

    public final AbstractTreeUi getUi() {
        return this.myUi;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.myUi.requestRelease();
    }

    void releaseUi() {
        this.myUi = null;
    }

    protected boolean updateNodeDescriptor(@NotNull NodeDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "updateNodeDescriptor"));
        }
        if (this.isDisposed()) {
            return false;
        }
        AbstractTreeUi ui = this.getUi();
        return ui != null && descriptor.update();
    }

    @Nullable
    public final DefaultTreeModel getTreeModel() {
        if (this.isDisposed()) {
            return null;
        }
        JTree tree = this.getTree();
        return tree == null ? null : (DefaultTreeModel)tree.getModel();
    }

    @NotNull
    public final Set<Object> getSelectedElements() {
        if (this.isDisposed()) {
            Set<Object> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getSelectedElements"));
            }
            return set;
        }
        Set<Object> set = this.getUi().getSelectedElements();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getSelectedElements"));
        }
        return set;
    }

    @NotNull
    public final <T> Set<T> getSelectedElements(@NotNull Class<T> elementClass) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getSelectedElements"));
        }
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Object o : this.getSelectedElements()) {
            Object each = this.transformElement(o);
            if (!elementClass.isInstance(each)) continue;
            result.add(each);
        }
        LinkedHashSet<Object> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getSelectedElements"));
        }
        return linkedHashSet;
    }

    protected Object transformElement(Object object) {
        return object;
    }

    public final void setCanYieldUpdate(boolean yield) {
        if (this.isDisposed()) {
            return;
        }
        this.getUi().setCanYield(yield);
    }

    @Nullable
    public static AbstractTreeBuilder getBuilderFor(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "getBuilderFor"));
        }
        WeakReference ref = (WeakReference)tree.getClientProperty(TREE_BUILDER);
        return (AbstractTreeBuilder)SoftReference.dereference((Reference)ref);
    }

    @Nullable
    public final <T> Object accept(@NotNull Class<?> nodeClass, @NotNull TreeVisitor<T> visitor) {
        if (nodeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeClass", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "accept"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "accept"));
        }
        return this.accept(nodeClass, this.getRootElement(), visitor);
    }

    @Nullable
    private <T> Object accept(@NotNull Class<?> nodeClass, Object element, @NotNull TreeVisitor<T> visitor) {
        Object[] children;
        if (nodeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeClass", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "accept"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "accept"));
        }
        if (element == null) {
            return null;
        }
        if (nodeClass.isAssignableFrom(element.getClass()) && visitor.visit(element)) {
            return element;
        }
        for (Object each : children = this.getTreeStructure().getChildElements(element)) {
            Object childObject = this.accept(nodeClass, each, visitor);
            if (childObject == null) continue;
            return childObject;
        }
        return null;
    }

    public <T> boolean select(@NotNull Class nodeClass, @NotNull TreeVisitor<T> visitor, @Nullable Runnable onDone, boolean addToSelection) {
        if (nodeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeClass", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "select"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "select"));
        }
        Object element = this.accept(nodeClass, visitor);
        if (element != null) {
            this.select(element, onDone, addToSelection);
            return true;
        }
        return false;
    }

    public void scrollSelectionToVisible(@Nullable Runnable onDone, boolean shouldBeCentered) {
        if (this.isDisposed()) {
            return;
        }
        this.myUi.scrollSelectionToVisible(onDone, shouldBeCentered);
    }

    private static boolean isUnitTestingMode() {
        Application app = ApplicationManager.getApplication();
        return app != null && app.isUnitTestMode();
    }

    public static boolean isToPaintSelection(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/AbstractTreeBuilder", "isToPaintSelection"));
        }
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        return builder == null || builder.getUi() == null || builder.getUi().isToPaintSelection();
    }

    public boolean isSelectionBeingAdjusted() {
        AbstractTreeUi ui = this.getUi();
        return ui != null && ui.isSelectionBeingAdjusted();
    }

    class UserRunnable
    implements Runnable {
        private final Runnable myRunnable;

        public UserRunnable(Runnable runnable) {
            this.myRunnable = runnable;
        }

        @Override
        public void run() {
            if (this.myRunnable != null) {
                AbstractTreeUi ui = AbstractTreeBuilder.this.getUi();
                if (ui != null) {
                    ui.executeUserRunnable(this.myRunnable);
                } else {
                    this.myRunnable.run();
                }
            }
        }
    }

    public static class AbstractTreeNodeWrapper
    extends AbstractTreeNode<Object> {
        public AbstractTreeNodeWrapper() {
            super((Project)null, null);
        }

        @Override
        @NotNull
        public Collection<AbstractTreeNode> getChildren() {
            List<AbstractTreeNode> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeBuilder$AbstractTreeNodeWrapper", "getChildren"));
            }
            return list;
        }

        @Override
        public void update(PresentationData presentation) {
        }
    }
}

