/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageFolding
extends LanguageExtension<FoldingBuilder> {
    public static final LanguageFolding INSTANCE = new LanguageFolding();

    private LanguageFolding() {
        super("com.intellij.lang.foldingBuilder");
    }

    @Override
    public FoldingBuilder forLanguage(@NotNull Language l) {
        FoldingBuilder result;
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/folding/LanguageFolding", "forLanguage"));
        }
        FoldingBuilder cached = (FoldingBuilder)l.getUserData(this.getLanguageCache());
        if (cached != null) {
            return cached;
        }
        List<FoldingBuilder> extensions = this.forKey(l);
        if (extensions.isEmpty()) {
            Language base = l.getBaseLanguage();
            result = base != null ? this.forLanguage(base) : (FoldingBuilder)this.getDefaultImplementation();
        } else {
            return extensions.size() == 1 ? (FoldingBuilder)extensions.get(0) : new CompositeFoldingBuilder(extensions);
        }
        l.putUserData(this.getLanguageCache(), result);
        return result;
    }

    @Override
    @NotNull
    public List<FoldingBuilder> allForLanguage(@NotNull Language l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/lang/folding/LanguageFolding", "allForLanguage"));
        }
        FoldingBuilder result = this.forLanguage(l);
        if (result == null) {
            List<FoldingBuilder> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/LanguageFolding", "allForLanguage"));
            }
            return list;
        }
        List<FoldingBuilder> list = result instanceof CompositeFoldingBuilder ? ((CompositeFoldingBuilder)result).getAllBuilders() : Collections.singletonList(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/LanguageFolding", "allForLanguage"));
        }
        return list;
    }

    @NotNull
    public static FoldingDescriptor[] buildFoldingDescriptors(@Nullable FoldingBuilder builder, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/folding/LanguageFolding", "buildFoldingDescriptors"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/folding/LanguageFolding", "buildFoldingDescriptors"));
        }
        if (!DumbService.isDumbAware(builder) && DumbService.getInstance(root.getProject()).isDumb()) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/LanguageFolding", "buildFoldingDescriptors"));
            }
            return FoldingDescriptor.EMPTY;
        }
        if (builder instanceof FoldingBuilderEx) {
            FoldingDescriptor[] foldingDescriptorArray = ((FoldingBuilderEx)builder).buildFoldRegions(root, document, quick);
            if (foldingDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/LanguageFolding", "buildFoldingDescriptors"));
            }
            return foldingDescriptorArray;
        }
        ASTNode astNode = root.getNode();
        if (astNode == null || builder == null) {
            if (FoldingDescriptor.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/LanguageFolding", "buildFoldingDescriptors"));
            }
            return FoldingDescriptor.EMPTY;
        }
        FoldingDescriptor[] foldingDescriptorArray = builder.buildFoldRegions(astNode, document);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/LanguageFolding", "buildFoldingDescriptors"));
        }
        return foldingDescriptorArray;
    }
}

