/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public abstract class WriteAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.application.WriteAction");

    @Override
    @NotNull
    public RunResult<T> execute() {
        final RunResult result = new RunResult(this);
        final Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            result.run();
            RunResult runResult = result;
            if (runResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "execute"));
            }
            return runResult;
        }
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AccessToken token = application.acquireWriteActionLock(WriteAction.this.getClass());
                try {
                    result.run();
                }
                finally {
                    token.finish();
                }
            }
        }, ModalityState.defaultModalityState());
        result.throwException();
        RunResult runResult = result;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "execute"));
        }
        return runResult;
    }

    @NotNull
    public static AccessToken start() {
        Class aClass = (Class)ObjectUtils.notNull((Object)ReflectionUtil.getGrandCallerClass(), WriteAction.class);
        AccessToken accessToken = WriteAction.start(aClass);
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "start"));
        }
        return accessToken;
    }

    @NotNull
    public static AccessToken start(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/application/WriteAction", "start"));
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireWriteActionLock(clazz);
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/WriteAction", "start"));
        }
        return accessToken;
    }
}

