/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;

public abstract class FilePatch {
    private String myBeforeName;
    private String myAfterName;
    private String myBeforeVersionId;
    private String myAfterVersionId;
    private String myBaseRevisionText;

    public String getBeforeName() {
        return this.myBeforeName;
    }

    public String getAfterName() {
        return this.myAfterName;
    }

    public String getBeforeFileName() {
        String[] pathNameComponents = this.myBeforeName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    public String getAfterFileName() {
        String[] pathNameComponents = this.myAfterName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    public void setBeforeName(String fileName) {
        this.myBeforeName = fileName;
    }

    public void setAfterName(String fileName) {
        this.myAfterName = fileName;
    }

    public String getBeforeVersionId() {
        return this.myBeforeVersionId;
    }

    public void setBeforeVersionId(String beforeVersionId) {
        this.myBeforeVersionId = beforeVersionId;
    }

    public String getAfterVersionId() {
        return this.myAfterVersionId;
    }

    public void setAfterVersionId(String afterVersionId) {
        this.myAfterVersionId = afterVersionId;
    }

    public String getAfterNameRelative(int skipDirs) {
        String[] components = this.myAfterName.split("/");
        return StringUtil.join((String[])components, (int)skipDirs, (int)components.length, (String)"/");
    }

    public String getBaseRevisionText() {
        return this.myBaseRevisionText;
    }

    public void setBaseRevisionText(String baseRevisionText) {
        this.myBaseRevisionText = baseRevisionText;
    }

    public abstract boolean isNewFile();

    public abstract boolean isDeletedFile();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePatch patch = (FilePatch)o;
        if (this.myBeforeName != null ? !this.myBeforeName.equals(patch.myBeforeName) : patch.myBeforeName != null) {
            return false;
        }
        if (this.myAfterName != null ? !this.myAfterName.equals(patch.myAfterName) : patch.myAfterName != null) {
            return false;
        }
        if (this.myBeforeVersionId != null ? !this.myBeforeVersionId.equals(patch.myBeforeVersionId) : patch.myBeforeVersionId != null) {
            return false;
        }
        if (this.myAfterVersionId != null ? !this.myAfterVersionId.equals(patch.myAfterVersionId) : patch.myAfterVersionId != null) {
            return false;
        }
        return !(this.myBaseRevisionText != null ? !this.myBaseRevisionText.equals(patch.myBaseRevisionText) : patch.myBaseRevisionText != null);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.myBeforeName, this.myAfterName, this.myBeforeVersionId, this.myAfterVersionId, this.myBaseRevisionText});
    }
}

