/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class IntegrationKey {
    @NotNull
    private final String myIdeProjectName;
    @NotNull
    private final String myIdeProjectLocationHash;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final String myExternalProjectConfigPath;

    public IntegrationKey(@NotNull Project ideProject, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectConfigPath) {
        if (ideProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProject", "com/intellij/openapi/externalSystem/util/IntegrationKey", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/IntegrationKey", "<init>"));
        }
        if (externalProjectConfigPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectConfigPath", "com/intellij/openapi/externalSystem/util/IntegrationKey", "<init>"));
        }
        this(ideProject.getName(), ideProject.getLocationHash(), externalSystemId, externalProjectConfigPath);
    }

    public IntegrationKey(@NotNull String ideProjectName, @NotNull String ideProjectLocationHash, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectConfigPath) {
        if (ideProjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProjectName", "com/intellij/openapi/externalSystem/util/IntegrationKey", "<init>"));
        }
        if (ideProjectLocationHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideProjectLocationHash", "com/intellij/openapi/externalSystem/util/IntegrationKey", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/util/IntegrationKey", "<init>"));
        }
        if (externalProjectConfigPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectConfigPath", "com/intellij/openapi/externalSystem/util/IntegrationKey", "<init>"));
        }
        this.myIdeProjectName = ideProjectName;
        this.myIdeProjectLocationHash = ideProjectLocationHash;
        this.myExternalSystemId = externalSystemId;
        this.myExternalProjectConfigPath = externalProjectConfigPath;
    }

    @NotNull
    public String getIdeProjectName() {
        String string = this.myIdeProjectName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/IntegrationKey", "getIdeProjectName"));
        }
        return string;
    }

    @NotNull
    public String getIdeProjectLocationHash() {
        String string = this.myIdeProjectLocationHash;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/IntegrationKey", "getIdeProjectLocationHash"));
        }
        return string;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/IntegrationKey", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public String getExternalProjectConfigPath() {
        String string = this.myExternalProjectConfigPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/util/IntegrationKey", "getExternalProjectConfigPath"));
        }
        return string;
    }

    public int hashCode() {
        int result = this.myIdeProjectName.hashCode();
        result = 31 * result + this.myIdeProjectLocationHash.hashCode();
        result = 31 * result + this.myExternalSystemId.hashCode();
        result = 31 * result + this.myExternalProjectConfigPath.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationKey key = (IntegrationKey)o;
        if (!this.myExternalSystemId.equals(key.myExternalSystemId)) {
            return false;
        }
        if (!this.myIdeProjectLocationHash.equals(key.myIdeProjectLocationHash)) {
            return false;
        }
        if (!this.myIdeProjectName.equals(key.myIdeProjectName)) {
            return false;
        }
        return this.myExternalProjectConfigPath.equals(key.myExternalProjectConfigPath);
    }

    public String toString() {
        return String.format("%s project '%s'", this.myExternalSystemId.toString().toLowerCase(), this.myIdeProjectName);
    }
}

