/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntaxHighlighterBase
implements SyntaxHighlighter {
    private static final Logger LOG = Logger.getInstance(SyntaxHighlighterBase.class);
    protected static final TextAttributesKey[] EMPTY = new TextAttributesKey[0];

    @NotNull
    public static TextAttributesKey[] pack(@Nullable TextAttributesKey key) {
        TextAttributesKey[] textAttributesKeyArray;
        if (key == null) {
            textAttributesKeyArray = EMPTY;
        } else {
            TextAttributesKey[] textAttributesKeyArray2 = new TextAttributesKey[1];
            textAttributesKeyArray = textAttributesKeyArray2;
            textAttributesKeyArray2[0] = key;
        }
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public static TextAttributesKey[] pack(@Nullable TextAttributesKey key1, @Nullable TextAttributesKey key2) {
        if (key1 == null) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack(key2);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
            }
            return textAttributesKeyArray;
        }
        if (key2 == null) {
            TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack(key1);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{key1, key2};
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public static TextAttributesKey[] pack(@NotNull TextAttributesKey[] base, @Nullable TextAttributesKey key) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        if (key == null) {
            if (base == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
            }
            return base;
        }
        TextAttributesKey[] result = new TextAttributesKey[base.length + 1];
        System.arraycopy(base, 0, result, 0, base.length);
        result[base.length] = key;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        return result;
    }

    @NotNull
    public static TextAttributesKey[] pack(@Nullable TextAttributesKey key, @NotNull TextAttributesKey[] base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        if (key == null) {
            if (base == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
            }
            return base;
        }
        TextAttributesKey[] result = new TextAttributesKey[base.length + 1];
        System.arraycopy(base, 0, result, 1, base.length);
        result[0] = key;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        return result;
    }

    @NotNull
    public static TextAttributesKey[] pack(@NotNull TextAttributesKey[] base, @Nullable TextAttributesKey t1, @Nullable TextAttributesKey t2) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        int add = 0;
        if (t1 != null) {
            ++add;
        }
        if (t2 != null) {
            ++add;
        }
        if (add == 0) {
            if (base == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
            }
            return base;
        }
        TextAttributesKey[] result = new TextAttributesKey[base.length + add];
        add = base.length;
        System.arraycopy(base, 0, result, 0, base.length);
        if (t1 != null) {
            result[add++] = t1;
        }
        if (t2 != null) {
            result[add] = t2;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "pack"));
        }
        return result;
    }

    protected static void fillMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull TokenSet keys, TextAttributesKey value) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "fillMap"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "fillMap"));
        }
        SyntaxHighlighterBase.fillMap(map, value, keys.getTypes());
    }

    protected static void fillMap(@NotNull Map<IElementType, TextAttributesKey> map, TextAttributesKey value, IElementType ... types) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "fillMap"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "fillMap"));
        }
        for (IElementType type : types) {
            map.put(type, value);
        }
    }

    protected static void safeMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull TokenSet keys, @NotNull TextAttributesKey value) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "safeMap"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "safeMap"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "safeMap"));
        }
        for (IElementType type : keys.getTypes()) {
            SyntaxHighlighterBase.safeMap(map, type, value);
        }
    }

    protected static void safeMap(@NotNull Map<IElementType, TextAttributesKey> map, @NotNull IElementType type, @NotNull TextAttributesKey value) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "safeMap"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "safeMap"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/fileTypes/SyntaxHighlighterBase", "safeMap"));
        }
        TextAttributesKey oldVal = map.put(type, value);
        if (oldVal != null && !oldVal.equals(value)) {
            LOG.error("Remapping highlighting for \"" + type + "\" val: old=" + oldVal + " new=" + value);
        }
    }
}

