/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesManagerFactory {
    @NotNull
    public <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> createSchemesManager(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/openapi/options/SchemesManagerFactory", "createSchemesManager"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerFactory", "createSchemesManager"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/options/SchemesManagerFactory", "createSchemesManager"));
        }
        SchemesManager<T, E> schemesManager = this.create(directoryName, processor, roamingType, null);
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "createSchemesManager"));
        }
        return schemesManager;
    }

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> create(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        SchemesManager<T, E> schemesManager = this.create(directoryName, processor, RoamingType.DEFAULT, null);
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        return schemesManager;
    }

    @NotNull
    public final <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> create(@NotNull String directoryName, @NotNull SchemeProcessor<E> processor, @NotNull String presentableName) {
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        SchemesManager<T, E> schemesManager = this.create(directoryName, processor, RoamingType.DEFAULT, presentableName);
        if (schemesManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "create"));
        }
        return schemesManager;
    }

    protected abstract <T extends Scheme, E extends ExternalizableScheme> SchemesManager<T, E> create(@NotNull String var1, @NotNull SchemeProcessor<E> var2, @NotNull RoamingType var3, @Nullable String var4);

    @NotNull
    public static SchemesManagerFactory getInstance() {
        SchemesManagerFactory schemesManagerFactory = ServiceManager.getService(SchemesManagerFactory.class);
        if (schemesManagerFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "getInstance"));
        }
        return schemesManagerFactory;
    }

    @NotNull
    public static SchemesManagerFactory getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/SchemesManagerFactory", "getInstance"));
        }
        SchemesManagerFactory schemesManagerFactory = ServiceManager.getService(project, SchemesManagerFactory.class);
        if (schemesManagerFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerFactory", "getInstance"));
        }
        return schemesManagerFactory;
    }
}

