/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.merge;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeDialogCustomizer {
    @Nullable
    public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/merge/MergeDialogCustomizer", "getMultipleFileMergeDescription"));
        }
        return null;
    }

    @Nullable
    public String getMergeWindowTitle(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/merge/MergeDialogCustomizer", "getMergeWindowTitle"));
        }
        return VcsBundle.message("multiple.file.merge.request.title", FileUtil.toSystemDependentName((String)file.getPresentableUrl()));
    }

    @Nullable
    public String getLeftPanelTitle(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/merge/MergeDialogCustomizer", "getLeftPanelTitle"));
        }
        return VcsBundle.message("merge.version.title.local.changes", new Object[0]);
    }

    @Nullable
    public String getCenterPanelTitle(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/merge/MergeDialogCustomizer", "getCenterPanelTitle"));
        }
        return VcsBundle.message("merge.version.title.merge.result", new Object[0]);
    }

    @Nullable
    public String getRightPanelTitle(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/merge/MergeDialogCustomizer", "getRightPanelTitle"));
        }
        if (revisionNumber != null) {
            return VcsBundle.message("merge.version.title.last.version.number", revisionNumber.asString());
        }
        return VcsBundle.message("merge.version.title.last.version", new Object[0]);
    }

    @NotNull
    public String getMultipleFileDialogTitle() {
        String string = VcsBundle.message("multiple.file.merge.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/merge/MergeDialogCustomizer", "getMultipleFileDialogTitle"));
        }
        return string;
    }
}

