/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.artifacts;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactTemplate;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.ui.ArtifactProblemsHolder;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArtifactType {
    public static final ExtensionPointName<ArtifactType> EP_NAME = ExtensionPointName.create((String)"com.intellij.packaging.artifactType");
    private final String myId;
    private final String myTitle;

    protected ArtifactType(@NonNls String id, String title) {
        this.myId = id;
        this.myTitle = title;
    }

    public final String getId() {
        return this.myId;
    }

    public String getPresentableName() {
        return this.myTitle;
    }

    @NotNull
    public abstract Icon getIcon();

    @Nullable
    public String getDefaultPathFor(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceItem", "com/intellij/packaging/artifacts/ArtifactType", "getDefaultPathFor"));
        }
        return this.getDefaultPathFor(sourceItem.getKindOfProducedElements());
    }

    @Nullable
    public abstract String getDefaultPathFor(@NotNull PackagingElementOutputKind var1);

    public boolean isSuitableItem(@NotNull PackagingSourceItem sourceItem) {
        if (sourceItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceItem", "com/intellij/packaging/artifacts/ArtifactType", "isSuitableItem"));
        }
        return true;
    }

    public static ArtifactType[] getAllTypes() {
        return (ArtifactType[])Extensions.getExtensions(EP_NAME);
    }

    @Nullable
    public static ArtifactType findById(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/packaging/artifacts/ArtifactType", "findById"));
        }
        for (ArtifactType type : ArtifactType.getAllTypes()) {
            if (!id.equals(type.getId())) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public abstract CompositePackagingElement<?> createRootElement(@NotNull String var1);

    @NotNull
    public List<? extends ArtifactTemplate> getNewArtifactTemplates(@NotNull PackagingElementResolvingContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/artifacts/ArtifactType", "getNewArtifactTemplates"));
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/artifacts/ArtifactType", "getNewArtifactTemplates"));
        }
        return list;
    }

    public void checkRootElement(@NotNull CompositePackagingElement<?> rootElement, @NotNull Artifact artifact, @NotNull ArtifactProblemsHolder manager) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/packaging/artifacts/ArtifactType", "checkRootElement"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/artifacts/ArtifactType", "checkRootElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/packaging/artifacts/ArtifactType", "checkRootElement"));
        }
    }

    @Nullable
    public List<? extends PackagingElement<?>> getSubstitution(@NotNull Artifact artifact, @NotNull PackagingElementResolvingContext context, @NotNull ArtifactType parentType) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/artifacts/ArtifactType", "getSubstitution"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/artifacts/ArtifactType", "getSubstitution"));
        }
        if (parentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentType", "com/intellij/packaging/artifacts/ArtifactType", "getSubstitution"));
        }
        return null;
    }
}

