/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PsiMethodCallPattern
extends PsiExpressionPattern<PsiMethodCallExpression, PsiMethodCallPattern> {
    PsiMethodCallPattern() {
        super(PsiMethodCallExpression.class);
    }

    public PsiMethodCallPattern withArguments(final ElementPattern<? extends PsiExpression> ... arguments) {
        return (PsiMethodCallPattern)this.with(new PatternCondition<PsiMethodCallExpression>("withArguments"){

            @Override
            public boolean accepts(@NotNull PsiMethodCallExpression callExpression, ProcessingContext context) {
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/patterns/PsiMethodCallPattern$1", "accepts"));
                }
                PsiExpression[] actualArguments = callExpression.getArgumentList().getExpressions();
                if (arguments.length != actualArguments.length) {
                    return false;
                }
                for (int i = 0; i < actualArguments.length; ++i) {
                    if (arguments[i].accepts(actualArguments[i], context)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public PsiMethodCallPattern withQualifier(final ElementPattern<? extends PsiExpression> qualifier) {
        return (PsiMethodCallPattern)this.with(new PatternCondition<PsiMethodCallExpression>("withQualifier"){

            @Override
            public boolean accepts(@NotNull PsiMethodCallExpression psiMethodCallExpression, ProcessingContext context) {
                if (psiMethodCallExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethodCallExpression", "com/intellij/patterns/PsiMethodCallPattern$2", "accepts"));
                }
                return qualifier.accepts(psiMethodCallExpression.getMethodExpression().getQualifierExpression(), context);
            }
        });
    }
}

