/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TextAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import org.jetbrains.annotations.NotNull;

public class ByTextArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final String myText;

    public ByTextArrangementEntryMatcher(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/codeStyle/arrangement/match/ByTextArrangementEntryMatcher", "<init>"));
        }
        this.myText = text;
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/psi/codeStyle/arrangement/match/ByTextArrangementEntryMatcher", "isMatched"));
        }
        if (entry instanceof TextAwareArrangementEntry) {
            return StringUtil.equals((CharSequence)((TextAwareArrangementEntry)entry).getText(), (CharSequence)this.myText);
        }
        return false;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByTextArrangementEntryMatcher)) {
            return false;
        }
        ByTextArrangementEntryMatcher matcher = (ByTextArrangementEntryMatcher)o;
        return this.myText.equals(matcher.myText);
    }

    public String toString() {
        return "with text " + this.myText;
    }
}

