/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import org.jetbrains.annotations.NotNull;

public class CodeStyleBoundedIntegerSettingPresentation
extends CodeStyleSettingPresentation {
    protected int myLowerBound;
    protected int myUpperBound;
    protected int myDefaultValue;
    protected String myDefaultValueUiName;

    public CodeStyleBoundedIntegerSettingPresentation(@NotNull String fieldName, @NotNull String uiName, int lowerBound, int upperBound, int defaultValue, String defaultValueUiName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/psi/codeStyle/presentation/CodeStyleBoundedIntegerSettingPresentation", "<init>"));
        }
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/psi/codeStyle/presentation/CodeStyleBoundedIntegerSettingPresentation", "<init>"));
        }
        super(fieldName, uiName);
        this.myLowerBound = lowerBound;
        this.myUpperBound = upperBound;
        this.myDefaultValue = defaultValue;
        this.myDefaultValueUiName = defaultValueUiName;
    }

    public int getLowerBound() {
        return this.myLowerBound;
    }

    public int getUpperBound() {
        return this.myUpperBound;
    }

    public int getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    @NotNull
    public String getValueUiName(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/codeStyle/presentation/CodeStyleBoundedIntegerSettingPresentation", "getValueUiName"));
        }
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            String string = intValue == this.myDefaultValue ? this.myDefaultValueUiName : super.getValueUiName(value);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/presentation/CodeStyleBoundedIntegerSettingPresentation", "getValueUiName"));
            }
            return string;
        }
        String string = super.getValueUiName(value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/presentation/CodeStyleBoundedIntegerSettingPresentation", "getValueUiName"));
        }
        return string;
    }
}

