/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;

public class WeightBasedComparator
implements Comparator<NodeDescriptor> {
    public static final int UNDEFINED_WEIGHT = Integer.MIN_VALUE;
    private final boolean myCompareToString;
    public static final WeightBasedComparator INSTANCE = new WeightBasedComparator();
    public static final WeightBasedComparator FULL_INSTANCE = new WeightBasedComparator(true){

        @Override
        protected int compareWeights(int w1, int w2) {
            return w1 - w2;
        }
    };

    public WeightBasedComparator() {
        this(false);
    }

    public WeightBasedComparator(boolean compareToString) {
        this.myCompareToString = compareToString;
    }

    @Override
    public int compare(NodeDescriptor o1, NodeDescriptor o2) {
        int w1 = this.getWeight(o1);
        int w2 = this.getWeight(o2);
        if (this.myCompareToString && w1 == w2) {
            return WeightBasedComparator.compareToString(o1, o2);
        }
        int weights = this.compareWeights(w1, w2);
        return weights != 0 ? weights : o1.getIndex() - o2.getIndex();
    }

    protected int getWeight(NodeDescriptor o1) {
        return o1.getWeight();
    }

    protected int compareWeights(int w1, int w2) {
        return w2 - w1;
    }

    protected static int compareToString(NodeDescriptor first, NodeDescriptor second) {
        return StringUtil.naturalCompare((String)first.toString(), (String)second.toString());
    }
}

