/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure.treetable;

import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private final JTree tree;
    private final TreeTableModel treeTableModel;
    private final JTable table;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree, JTable table) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        this.table = table;
        this.treeTableModel.setTree(tree);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath == null ? null : treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object o = this.nodeForRow(row);
        return o == null ? null : this.treeTableModel.getValueAt(o, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Object o = this.nodeForRow(row);
        return o != null && this.treeTableModel.isCellEditable(o, column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        Object o = this.nodeForRow(row);
        if (o != null) {
            this.treeTableModel.setValueAt(value, o, column);
        }
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public void fireTableDataChanged() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        super.fireTableDataChanged();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                int row = this.tree.getRowForPath(treePath);
                this.table.getSelectionModel().addSelectionInterval(row, row);
            }
        }
    }
}

