/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposeAwareRunnable
extends WeakReference<Object>
implements Runnable {
    protected final Runnable myDelegate;

    public static Runnable create(@NotNull Runnable delegate, @Nullable PsiElement disposable) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/DisposeAwareRunnable", "create"));
        }
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    public static Runnable create(@NotNull Runnable delegate, @Nullable Project disposable) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/DisposeAwareRunnable", "create"));
        }
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    public static Runnable create(@NotNull Runnable delegate, @Nullable Module disposable) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/DisposeAwareRunnable", "create"));
        }
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    private static Runnable create(@NotNull Runnable delegate, @Nullable Object disposable) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/DisposeAwareRunnable", "create"));
        }
        if (disposable == null) {
            return delegate;
        }
        if (delegate instanceof DumbAware) {
            return new DumbAwareRunnable(delegate, disposable);
        }
        if (delegate instanceof PossiblyDumbAware) {
            return new PossiblyDumbAwareRunnable(delegate, disposable);
        }
        return new DisposeAwareRunnable(delegate, disposable);
    }

    private DisposeAwareRunnable(@NotNull Runnable delegate, @NotNull Object disposable) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/util/DisposeAwareRunnable", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/util/DisposeAwareRunnable", "<init>"));
        }
        super(disposable);
        this.myDelegate = delegate;
        assert (disposable instanceof PsiElement || disposable instanceof ComponentManager) : "Unknown type of " + disposable;
    }

    @Override
    public void run() {
        Object res = this.get();
        if (res == null) {
            return;
        }
        if (res instanceof PsiElement ? !((PsiElement)res).isValid() : res instanceof ComponentManager && ((ComponentManager)res).isDisposed()) {
            return;
        }
        this.myDelegate.run();
    }

    private static class PossiblyDumbAwareRunnable
    extends DisposeAwareRunnable
    implements PossiblyDumbAware {
        PossiblyDumbAwareRunnable(Runnable delegate, Object disposable) {
            super(delegate, disposable);
        }

        @Override
        public boolean isDumbAware() {
            return ((PossiblyDumbAware)((Object)this.myDelegate)).isDumbAware();
        }
    }

    private static class DumbAwareRunnable
    extends DisposeAwareRunnable
    implements DumbAware {
        DumbAwareRunnable(Runnable delegate, Object disposable) {
            super(delegate, disposable);
        }
    }
}

