/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateWrapper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateUtil {
    public static final String X509 = "X.509";
    public static final String JKS = "JKS";
    public static final String PKCS12 = "PKCS12";
    public static final String PKIX = "PKIX";
    public static final String TLS = "TLS";
    private static final CertificateFactory ourFactory = CertificateUtil.createFactory();

    private static CertificateFactory createFactory() {
        try {
            return CertificateFactory.getInstance(X509);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Can't initialize X.509 certificate factory", e);
        }
    }

    private CertificateUtil() {
    }

    @Nullable
    public static X509Certificate loadX509Certificate(@NotNull String path2) {
        X509Certificate x509Certificate;
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/net/ssl/CertificateUtil", "loadX509Certificate"));
        }
        FileInputStream stream = new FileInputStream(path2);
        try {
            x509Certificate = (X509Certificate)ourFactory.generateCertificate(stream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (Exception e) {
                Logger.getInstance(CertificateUtil.class).error("Can't add certificate for path: " + path2, (Throwable)e);
                return null;
            }
        }
        ((InputStream)stream).close();
        return x509Certificate;
    }

    public static String getCommonName(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/util/net/ssl/CertificateUtil", "getCommonName"));
        }
        return new CertificateWrapper(certificate).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
    }
}

