/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;

public class URLsUtil {
    public static final String FILE = "file";
    public static final String PROTOCOL_DELIMITER = ":";
    public static final String JAR_DELIMITER = "!";

    public static boolean startsWithChar(CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    public static String extractRoot(URL resourceURL, String resourcePath) {
        String archivePath;
        String fullPath;
        int delimiter;
        if (!URLsUtil.startsWithChar(resourcePath, '/') && !URLsUtil.startsWithChar(resourcePath, '\\')) {
            System.err.println("precondition failed: " + resourcePath);
            return null;
        }
        String protocol = resourceURL.getProtocol();
        String resultPath = null;
        if (FILE.equals(protocol)) {
            String testResourcePath;
            String path = resourceURL.getFile();
            String testPath = path.replace('\\', '/');
            if (URLsUtil.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol) && (delimiter = (fullPath = resourceURL.getFile()).indexOf(JAR_DELIMITER)) >= 0 && URLsUtil.startsWithConcatenationOf(archivePath = fullPath.substring(0, delimiter), FILE, PROTOCOL_DELIMITER)) {
            resultPath = archivePath.substring(FILE.length() + PROTOCOL_DELIMITER.length());
        }
        if (resultPath == null) {
            System.err.println("cannot extract: " + resultPath + " from " + resourceURL);
            return null;
        }
        if (resourcePath.endsWith(File.separator)) {
            resultPath = resultPath.substring(0, resultPath.lastIndexOf(File.separator));
        }
        resultPath = URLsUtil.unescapePercentSequences(resultPath);
        return resultPath;
    }

    public static boolean startsWithConcatenationOf(String testee, String firstPrefix, String secondPrefix) {
        int l1 = firstPrefix.length();
        int l2 = secondPrefix.length();
        if (testee.length() < l1 + l2) {
            return false;
        }
        return testee.startsWith(firstPrefix) && testee.regionMatches(l1, secondPrefix, 0, l2);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength;
        int stringLength = str.length();
        return stringLength >= (suffixLength = suffix.length()) && str.regionMatches(true, stringLength - suffixLength, suffix, 0, suffixLength);
    }

    public static String unescapePercentSequences(String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                ArrayList<Integer> bytes = new ArrayList<Integer>();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLsUtil.decode(s.charAt(i + 1));
                    int d2 = URLsUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add(new Integer((d1 & 0xF) << 4 | d2 & 0xF));
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = (byte)((Integer)bytes.get(j)).intValue();
                    }
                    try {
                        decoded.append(new String(bytesArray, "UTF-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException ignored) {
                        // empty catch block
                    }
                }
            }
            decoded.append(c);
            ++i;
        }
        return decoded.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }
}

