/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.Jar;

public class Ear
extends Jar {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myAppDirName;
    @NotNull
    private final String myLibDirName;
    private String myDeploymentDescriptor;
    @NotNull
    private List<EarResource> myResources;

    public Ear(@NotNull String name, @NotNull String appDirName, @NotNull String libDirName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/gradle/model/data/Ear", "<init>"));
        }
        if (appDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appDirName", "org/jetbrains/plugins/gradle/model/data/Ear", "<init>"));
        }
        if (libDirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libDirName", "org/jetbrains/plugins/gradle/model/data/Ear", "<init>"));
        }
        super(name);
        this.myResources = Collections.emptyList();
        this.myAppDirName = appDirName;
        this.myLibDirName = libDirName;
    }

    @NotNull
    public String getAppDirName() {
        String string = this.myAppDirName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/Ear", "getAppDirName"));
        }
        return string;
    }

    @NotNull
    public String getLibDirName() {
        String string = this.myLibDirName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/Ear", "getLibDirName"));
        }
        return string;
    }

    public void setDeploymentDescriptor(String deploymentDescriptor) {
        this.myDeploymentDescriptor = deploymentDescriptor;
    }

    public String getDeploymentDescriptor() {
        return this.myDeploymentDescriptor;
    }

    @NotNull
    public List<EarResource> getResources() {
        List<EarResource> list = this.myResources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/Ear", "getResources"));
        }
        return list;
    }

    public void setResources(@NotNull List<EarResource> resources) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "org/jetbrains/plugins/gradle/model/data/Ear", "setResources"));
        }
        this.myResources = resources;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Ear)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Ear that = (Ear)o;
        if (!this.myAppDirName.equals(that.myAppDirName)) {
            return false;
        }
        return this.myLibDirName.equals(that.myLibDirName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myAppDirName.hashCode();
        result = 31 * result + this.myLibDirName.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Ear{appDirName='" + this.myAppDirName + '\'' + ", libDirName='" + this.myLibDirName + '\'' + '}';
    }
}

