/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class EarResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myEarDirectory;
    @NotNull
    private final String relativePath;
    @NotNull
    private final File file;

    public EarResource(@NotNull String earDirectory, @NotNull String relativePath, @NotNull File file) {
        if (earDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earDirectory", "org/jetbrains/plugins/gradle/model/data/EarResource", "<init>"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/plugins/gradle/model/data/EarResource", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/gradle/model/data/EarResource", "<init>"));
        }
        this.myEarDirectory = earDirectory;
        this.relativePath = EarResource.getAdjustedPath(relativePath);
        this.file = file;
    }

    @NotNull
    public String getEarDirectory() {
        String string = this.myEarDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/EarResource", "getEarDirectory"));
        }
        return string;
    }

    @NotNull
    public String getRelativePath() {
        String string = this.relativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/EarResource", "getRelativePath"));
        }
        return string;
    }

    @NotNull
    public File getFile() {
        File file = this.file;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/data/EarResource", "getFile"));
        }
        return file;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/model/data/EarResource", "getAdjustedPath"));
        }
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarResource)) {
            return false;
        }
        EarResource resource = (EarResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.myEarDirectory != resource.myEarDirectory) {
            return false;
        }
        return this.relativePath.equals(resource.relativePath);
    }

    public int hashCode() {
        int result = this.myEarDirectory.hashCode();
        result = 31 * result + this.relativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "Resource{earDirectory=" + this.myEarDirectory + ", relativePath='" + this.relativePath + '\'' + ", file=" + this.file + '}';
    }
}

