/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.esotericsoftware.minlog.Log;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalPlugin;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class ExternalProjectSerializer {
    private static final Logger LOG = Logger.getInstance(ExternalProjectSerializer.class);
    private final Kryo myKryo = new Kryo(){

        public <T> T newInstance(Class<T> type) {
            LOG.error("Serializing default type: " + type);
            return (T)super.newInstance(type);
        }
    };

    public ExternalProjectSerializer() {
        this.configureKryo();
    }

    private void configureKryo() {
        this.myKryo.setAutoReset(true);
        this.myKryo.setRegistrationRequired(true);
        Log.set((int)4);
        this.myKryo.register(ArrayList.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new ArrayList();
            }
        });
        this.myKryo.register(HashMap.class, (Serializer)new MapSerializer(){

            protected Map create(Kryo kryo, Input input, Class<Map> type) {
                return new HashMap();
            }
        });
        this.myKryo.register(HashSet.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new HashSet();
            }
        });
        this.myKryo.register(File.class, (Serializer)new FileSerializer());
        this.myKryo.register(DefaultExternalProject.class, (Serializer)new FieldSerializer<DefaultExternalProject>(this.myKryo, DefaultExternalProject.class){

            protected DefaultExternalProject create(Kryo kryo, Input input, Class<DefaultExternalProject> type) {
                return new DefaultExternalProject();
            }
        });
        this.myKryo.register(DefaultExternalTask.class, (Serializer)new FieldSerializer<DefaultExternalTask>(this.myKryo, DefaultExternalTask.class){

            protected DefaultExternalTask create(Kryo kryo, Input input, Class<DefaultExternalTask> type) {
                return new DefaultExternalTask();
            }
        });
        this.myKryo.register(DefaultExternalPlugin.class, (Serializer)new FieldSerializer<DefaultExternalPlugin>(this.myKryo, DefaultExternalPlugin.class){

            protected DefaultExternalPlugin create(Kryo kryo, Input input, Class<DefaultExternalPlugin> type) {
                return new DefaultExternalPlugin();
            }
        });
        this.myKryo.register(DefaultExternalSourceSet.class, (Serializer)new FieldSerializer<DefaultExternalSourceSet>(this.myKryo, DefaultExternalSourceSet.class){

            protected DefaultExternalSourceSet create(Kryo kryo, Input input, Class<DefaultExternalSourceSet> type) {
                return new DefaultExternalSourceSet();
            }
        });
        this.myKryo.register(DefaultExternalSourceDirectorySet.class, (Serializer)new FieldSerializer<DefaultExternalSourceDirectorySet>(this.myKryo, DefaultExternalSourceDirectorySet.class){

            protected DefaultExternalSourceDirectorySet create(Kryo kryo, Input input, Class<DefaultExternalSourceDirectorySet> type) {
                return new DefaultExternalSourceDirectorySet();
            }
        });
        this.myKryo.register(DefaultExternalFilter.class, (Serializer)new FieldSerializer<DefaultExternalFilter>(this.myKryo, DefaultExternalFilter.class){

            protected DefaultExternalFilter create(Kryo kryo, Input input, Class<DefaultExternalFilter> type) {
                return new DefaultExternalFilter();
            }
        });
        this.myKryo.register(ExternalSystemSourceType.class, (Serializer)new DefaultSerializers.EnumSerializer(ExternalSystemSourceType.class));
        this.myKryo.register(DefaultExternalProjectDependency.class, (Serializer)new FieldSerializer<DefaultExternalProjectDependency>(this.myKryo, DefaultExternalProjectDependency.class){

            protected DefaultExternalProjectDependency create(Kryo kryo, Input input, Class<DefaultExternalProjectDependency> type) {
                return new DefaultExternalProjectDependency();
            }
        });
        this.myKryo.register(DefaultFileCollectionDependency.class, (Serializer)new FieldSerializer<DefaultFileCollectionDependency>(this.myKryo, DefaultFileCollectionDependency.class){

            protected DefaultFileCollectionDependency create(Kryo kryo, Input input, Class<DefaultFileCollectionDependency> type) {
                return new DefaultFileCollectionDependency();
            }
        });
        this.myKryo.register(DefaultExternalLibraryDependency.class, (Serializer)new FieldSerializer<DefaultExternalLibraryDependency>(this.myKryo, DefaultExternalLibraryDependency.class){

            protected DefaultExternalLibraryDependency create(Kryo kryo, Input input, Class<DefaultExternalLibraryDependency> type) {
                return new DefaultExternalLibraryDependency();
            }
        });
        this.myKryo.register(DefaultUnresolvedExternalDependency.class, (Serializer)new FieldSerializer<DefaultUnresolvedExternalDependency>(this.myKryo, DefaultUnresolvedExternalDependency.class){

            protected DefaultUnresolvedExternalDependency create(Kryo kryo, Input input, Class<DefaultUnresolvedExternalDependency> type) {
                return new DefaultUnresolvedExternalDependency();
            }
        });
        this.myKryo.register(DefaultExternalDependencyId.class, (Serializer)new FieldSerializer<DefaultExternalDependencyId>(this.myKryo, DefaultExternalDependencyId.class){

            protected DefaultExternalDependencyId create(Kryo kryo, Input input, Class<DefaultExternalDependencyId> type) {
                return new DefaultExternalDependencyId();
            }
        });
        this.myKryo.register(LinkedHashSet.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new LinkedHashSet();
            }
        });
        this.myKryo.register(HashSet.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new HashSet();
            }
        });
        this.myKryo.register(THashSet.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new THashSet();
            }
        });
        this.myKryo.register(Set.class, (Serializer)new CollectionSerializer(){

            protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
                return new HashSet();
            }
        });
        this.myKryo.register(THashMap.class, (Serializer)new MapSerializer(){

            protected Map create(Kryo kryo, Input input, Class<Map> type) {
                return new THashMap();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProject", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectSerializer", "save"));
        }
        Output output = null;
        try {
            File externalProjectDir = externalProject.getProjectDir();
            File configurationFile = ExternalProjectSerializer.getProjectConfigurationFile(new ProjectSystemId(externalProject.getExternalSystemId()), externalProjectDir);
            if (!FileUtil.createParentDirs((File)configurationFile)) {
                return;
            }
            output = new Output((OutputStream)new FileOutputStream(configurationFile));
            this.myKryo.writeObject(output, (Object)externalProject);
            LOG.debug("Data saved for imported project from: " + externalProjectDir.getPath());
            StreamUtil.closeStream((Closeable)output);
        }
        catch (FileNotFoundException e) {
            LOG.error((Throwable)e);
        }
        finally {
            StreamUtil.closeStream(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExternalProject load(@NotNull ProjectSystemId externalSystemId, File externalProjectPath) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "org/jetbrains/plugins/gradle/service/project/data/ExternalProjectSerializer", "load"));
        }
        LOG.debug("Attempt to load project data from: " + externalProjectPath);
        ExternalProject externalProject = null;
        try {
            File configurationFile = ExternalProjectSerializer.getProjectConfigurationFile(externalSystemId, externalProjectPath);
            if (!configurationFile.isFile()) {
                return null;
            }
            Input input = new Input((InputStream)new FileInputStream(configurationFile));
            try {
                externalProject = (ExternalProject)this.myKryo.readObject(input, DefaultExternalProject.class);
            }
            finally {
                StreamUtil.closeStream((Closeable)input);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        if (externalProject != null) {
            LOG.debug("Loaded project: " + externalProject.getProjectDir());
        }
        return externalProject;
    }

    private static File getProjectConfigurationFile(ProjectSystemId externalSystemId, File externalProjectPath) {
        return new File(ExternalProjectSerializer.getProjectConfigurationDir(externalSystemId), Integer.toHexString(ExternalSystemUtil.fileHashCode((File)externalProjectPath)) + "/project.dat");
    }

    private static File getProjectConfigurationDir(ProjectSystemId externalSystemId) {
        return ExternalProjectSerializer.getPluginSystemDir(externalSystemId, "Projects");
    }

    private static File getPluginSystemDir(ProjectSystemId externalSystemId, String folder) {
        return new File(PathManager.getSystemPath(), externalSystemId.getId().toLowerCase() + "/" + folder).getAbsoluteFile();
    }

    private static class FileSerializer
    extends Serializer<File> {
        private final Kryo myStdKryo = new Kryo();

        public FileSerializer() {
            this.myStdKryo.register(File.class);
            this.myStdKryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        }

        public void write(Kryo kryo, Output output, File object) {
            this.myStdKryo.writeObject(output, (Object)object);
        }

        public File read(Kryo kryo, Input input, Class<File> type) {
            File file = (File)this.myStdKryo.readObject(input, File.class);
            return new File(file.getPath());
        }
    }
}

