/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.classFinder.ClassPathEntry;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassFinder {
    private List myIncludePatterns;
    private List myExcludePatterns;
    private Set myClassloaders;

    public ClassFinder(List includePatterns, List excludePatterns) {
        this.myIncludePatterns = includePatterns;
        this.myExcludePatterns = excludePatterns;
        this.myClassloaders = new HashSet();
    }

    public void addClassLoader(ClassLoader cl) {
        if (cl != null) {
            if (cl.getClass().getName().equals("jetbrains.buildServer.agent.AgentClassLoader")) {
                return;
            }
            if (cl instanceof URLClassLoader) {
                this.myClassloaders.add(cl);
            }
            if (cl.getParent() != null) {
                this.addClassLoader(cl.getParent());
            }
        }
    }

    public Collection findMatchedClasses() {
        HashSet classes = new HashSet();
        for (ClassPathEntry entry : this.getClassPathEntries()) {
            try {
                classes.addAll(entry.getClassesIterator(this.myIncludePatterns, this.myExcludePatterns));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    protected Collection getClassPathEntries() {
        HashSet result = new HashSet();
        result.addAll(ClassFinder.extractEntries(System.getProperty("java.class.path")));
        result.addAll(ClassFinder.extractEntries(System.getProperty("sun.boot.class.path")));
        this.collectClassloaderEntries(result);
        return result;
    }

    private void collectClassloaderEntries(Set result) {
        for (URLClassLoader cl : this.myClassloaders) {
            try {
                URL[] urls = cl.getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    String path;
                    URL url = urls[i];
                    if (!"file".equals(url.getProtocol()) || (path = this.fixPath(url.getPath())) == null) continue;
                    result.add(new ClassPathEntry(path, cl));
                }
            }
            catch (Exception e) {
                System.out.println("Exception occurred on trying collect ClassPath URLs. One of possible reasons is shutting down Tomcat before finishing tests. Coverage won't be affected but some of uncovered classes could be missing from the report.");
                e.printStackTrace();
            }
        }
    }

    private String fixPath(String path) {
        String result = path;
        try {
            result = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (result.length() == 0) {
            return result;
        }
        if (result.charAt(0) == '/' && result.length() > 3 && result.charAt(2) == ':') {
            result = result.substring(1);
        }
        return result;
    }

    private static Collection extractEntries(String classPath) {
        if (classPath == null) {
            return Collections.emptyList();
        }
        String[] entries = classPath.split(System.getProperty("path.separator"));
        HashSet<ClassPathEntry> result = new HashSet<ClassPathEntry>();
        for (int i = 0; i < entries.length; ++i) {
            result.add(new ClassPathEntry(entries[i], null));
        }
        return result;
    }
}

