/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.NewChildEvent;
import com.intellij.execution.junit2.events.StateChangedEvent;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.ui.model.CompletionEvent;
import com.intellij.execution.junit2.ui.model.JUnitAdapter;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import javax.swing.DefaultBoundedRangeModel;

public class TestProgress
extends DefaultBoundedRangeModel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.TestProgress");
    private int myProblemsCounter = 0;
    private TestProxy myCurrentState = null;
    private final MyJUnitListener myListener = new MyJUnitListener();
    private int myMissingChildren;
    private Project myProject;
    public static final Filter TEST_CASE = new Filter(){

        public boolean shouldAccept(AbstractTestProxy test) {
            return test.shouldRun();
        }
    };
    private CompletionEvent myDone;

    public TestProgress() {
        super(0, 0, 0, 0);
    }

    public TestProgress(JUnitRunningModel model) {
        this();
        this.setModel(model);
    }

    public void setModel(JUnitRunningModel model) {
        this.myMissingChildren = 0;
        this.myProject = model.getProject();
        int knownTestCases = TEST_CASE.select(model.getRoot().getAllTests()).size();
        int declaredTestCases = model.getRoot().getInfo().getTestsCount();
        if (declaredTestCases > knownTestCases) {
            this.myMissingChildren = declaredTestCases - knownTestCases;
        }
        this.setMaximum(knownTestCases + this.myMissingChildren);
        model.addListener(this.myListener);
    }

    public int countDefects() {
        return this.myProblemsCounter;
    }

    public boolean hasDefects() {
        return this.countDefects() > 0;
    }

    public TestProxy getCurrentTest() {
        return this.myCurrentState;
    }

    private void setCurrentState(TestProxy currentState) {
        this.myCurrentState = currentState;
        this.fireStateChanged();
    }

    public CompletionEvent getDone() {
        return this.myDone;
    }

    public void setDone(CompletionEvent done) {
        this.myDone = done;
    }

    @Override
    public void setValue(int n) {
        super.setValue(n);
        TestsUIUtil.showIconProgress((Project)this.myProject, (int)n, (int)this.getMaximum(), (int)this.myProblemsCounter, (boolean)false);
    }

    public void dispose() {
        TestsUIUtil.clearIconProgress((Project)this.myProject);
    }

    private class MyJUnitListener
    extends JUnitAdapter {
        private MyJUnitListener() {
        }

        @Override
        public void onTestChanged(TestEvent event) {
            if (event instanceof StateChangedEvent) {
                this.onChanged((StateChangedEvent)event);
            }
            if (event instanceof NewChildEvent) {
                this.onChildAdded((NewChildEvent)event);
            }
        }

        public void onChanged(StateChangedEvent event) {
            TestProxy test = event.getSource();
            if (!test.isLeaf()) {
                return;
            }
            int stateMagnitude = test.getState().getMagnitude();
            if (test.getState().isFinal()) {
                if (!test.getInfo().shouldRun()) {
                    this.newTestAppeared();
                }
                if (TestProgress.this.getValue() >= TestProgress.this.getMaximum()) {
                    String message = "State changed: " + (Object)((Object)test) + " state: " + stateMagnitude + " Max: " + TestProgress.this.getMaximum() + " Value: " + TestProgress.this.getValue();
                    LOG.error(message);
                }
                if (test.getState().isDefect()) {
                    TestProgress.this.myProblemsCounter++;
                }
                TestProgress.this.setValue(TestProgress.this.getValue() + 1);
            }
            TestProgress.this.setCurrentState(stateMagnitude == 3 ? test : null);
        }

        public void onChildAdded(NewChildEvent event) {
            if (event.getChild().getInfo().shouldRun()) {
                this.newTestAppeared();
            }
        }

        private void newTestAppeared() {
            if (TestProgress.this.myMissingChildren == 0) {
                TestProgress.this.setMaximum(TestProgress.this.getMaximum() + 1);
            } else {
                TestProgress.this.myMissingChildren--;
            }
        }
    }
}

