/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.model;

import com.intellij.execution.junit2.TestProxy;
import com.intellij.execution.junit2.events.TestEvent;
import com.intellij.execution.junit2.events.TestEventsConsumer;
import com.intellij.execution.junit2.segments.DispatchListener;
import com.intellij.execution.junit2.ui.model.Flag;
import com.intellij.execution.junit2.ui.model.JUnitListener;
import com.intellij.execution.junit2.ui.model.JUnitRunningModel;
import com.intellij.execution.junit2.ui.model.StateEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JUnitListenersNotifier
implements TestEventsConsumer,
DispatchListener,
Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.ui.model.JUnitListenersNotifier");
    private final ArrayList<JUnitListener> myListeners = new ArrayList();
    private final ArrayList<TestEvent> myEventsQueue = new ArrayList();
    private final Flag myCollectingEvents = new Flag(LOG, true);
    private final Alarm myAlarm = new Alarm();
    private final boolean myDeferEvents;

    public JUnitListenersNotifier(boolean deferEvents) {
        this.myDeferEvents = deferEvents;
    }

    public JUnitListenersNotifier() {
        this(!ApplicationManager.getApplication().isUnitTestMode());
    }

    public void fireTestSelected(TestProxy test) {
        JUnitListener[] listeners;
        for (JUnitListener listener : listeners = this.getListeners()) {
            listener.onTestSelected(test);
        }
    }

    public void fireDisposed(JUnitRunningModel model) {
        JUnitListener[] listeners;
        for (JUnitListener listener : listeners = this.getListeners()) {
            listener.onDispose(model);
        }
    }

    private void dispatchTestEvent(TestEvent event) {
        JUnitListener[] listeners;
        for (JUnitListener listener : listeners = this.getListeners()) {
            listener.onTestChanged(event);
        }
    }

    public void fireRunnerStateChanged(StateEvent event) {
        JUnitListener[] listeners;
        for (JUnitListener listener : listeners = this.getListeners()) {
            listener.onRunnerStateChanged(event);
        }
        if (!this.myCollectingEvents.getValue()) {
            this.myAlarm.cancelAllRequests();
            this.dispatchAllEvents();
        }
    }

    public void fireEventsDispatched(List<TestEvent> events) {
        JUnitListener[] listeners;
        for (JUnitListener listener : listeners = this.getListeners()) {
            listener.onEventsDispatched(events);
        }
    }

    private JUnitListener[] getListeners() {
        return this.myListeners.toArray(new JUnitListener[this.myListeners.size()]);
    }

    public void addListener(@NotNull JUnitListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/junit2/ui/model/JUnitListenersNotifier", "addListener"));
        }
        this.myListeners.add(listener);
    }

    public void removeListener(JUnitListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void onEvent(TestEvent event) {
        if (this.myEventsQueue.isEmpty() && this.myDeferEvents) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest((Runnable)this, 400);
        }
        this.myEventsQueue.add(event);
    }

    public void onStarted() {
        this.myCollectingEvents.assertValue(false);
        this.myCollectingEvents.setValue(true);
    }

    public void onFinished() {
        this.myCollectingEvents.assertValue(true);
        this.myCollectingEvents.setValue(false);
        if (!this.myDeferEvents) {
            this.run();
        }
    }

    @Override
    public void run() {
        this.myCollectingEvents.assertValue(false);
        this.dispatchAllEvents();
    }

    private void dispatchAllEvents() {
        List<TestEvent> filteredEvents = JUnitListenersNotifier.removeDuplicates(this.myEventsQueue);
        this.myEventsQueue.clear();
        for (TestEvent event : filteredEvents) {
            this.dispatchTestEvent(event);
        }
        this.fireEventsDispatched(filteredEvents);
    }

    private static <T> List<T> removeDuplicates(List<T> list) {
        ArrayList<T> result = new ArrayList<T>(list.size());
        HashSet<T> collected = new HashSet<T>();
        for (T t : list) {
            if (collected.contains(t)) continue;
            collected.add(t);
            result.add(t);
        }
        return result;
    }
}

