/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.java.decompiler.modules.decompiler.LowBreakHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class EliminateLoopsHelper {
    private static boolean eliminateLoopsRec(Statement stat) {
        for (Statement st : stat.getStats()) {
            if (!EliminateLoopsHelper.eliminateLoopsRec(st)) continue;
            return true;
        }
        return stat.type == 5 && EliminateLoopsHelper.isLoopRedundant((DoStatement)stat);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isLoopRedundant(DoStatement loop) {
        Statement parentloop;
        if (loop.getLooptype() != 0) {
            return false;
        }
        for (parentloop = loop.getParent(); parentloop != null && parentloop.type != 5; parentloop = parentloop.getParent()) {
        }
        if (parentloop == null || parentloop.getBasichead() != loop.getBasichead()) {
            return false;
        }
        ArrayList<StatEdge> lstBreakEdges = new ArrayList<StatEdge>();
        for (StatEdge edge : loop.getLabelEdges()) {
            if (edge.getType() != 4) continue;
            lstBreakEdges.add(edge);
        }
        Statement loopcontent = loop.getFirst();
        boolean firstok = loopcontent.getAllSuccessorEdges().isEmpty();
        if (!firstok) {
            StatEdge edge = loopcontent.getAllSuccessorEdges().get(0);
            boolean bl = firstok = edge.closure == loop && edge.getType() == 4;
            if (firstok) {
                lstBreakEdges.remove(edge);
            }
        }
        if (!lstBreakEdges.isEmpty()) {
            if (firstok) {
                void var9_32;
                void var8_20;
                void var8_18;
                void var8_15;
                void var8_13;
                HashMap<Integer, Boolean> statLabeled = new HashMap<Integer, Boolean>();
                ArrayList<Statement> lstEdgeClosures = new ArrayList<Statement>();
                for (StatEdge statEdge : lstBreakEdges) {
                    Statement statement = LowBreakHelper.getMinClosure(loopcontent, statEdge.getSource());
                    lstEdgeClosures.add(statement);
                }
                int precount = loop.isLabeled() ? 1 : 0;
                for (Statement statement : lstEdgeClosures) {
                    if (statLabeled.containsKey(statement.id)) continue;
                    boolean btemp = statement.isLabeled();
                    precount += btemp ? 1 : 0;
                    statLabeled.put(statement.id, btemp);
                }
                boolean bl = false;
                while (var8_13 < lstBreakEdges.size()) {
                    Statement statement = (Statement)lstEdgeClosures.get((int)var8_13);
                    statLabeled.put(statement.id, LowBreakHelper.isBreakEdgeLabeled(((StatEdge)lstBreakEdges.get((int)var8_13)).getSource(), statement) | (Boolean)statLabeled.get(statement.id));
                    ++var8_13;
                }
                boolean bl2 = false;
                while (var8_15 < lstBreakEdges.size()) {
                    lstEdgeClosures.set((int)var8_15, EliminateLoopsHelper.getMaxBreakLift((Statement)lstEdgeClosures.get((int)var8_15), (StatEdge)lstBreakEdges.get((int)var8_15), statLabeled, loop));
                    ++var8_15;
                }
                statLabeled.clear();
                for (Statement statement : lstEdgeClosures) {
                    statLabeled.put(statement.id, statement.isLabeled());
                }
                boolean bl3 = false;
                while (var8_18 < lstBreakEdges.size()) {
                    Statement statement = (Statement)lstEdgeClosures.get((int)var8_18);
                    statLabeled.put(statement.id, LowBreakHelper.isBreakEdgeLabeled(((StatEdge)lstBreakEdges.get((int)var8_18)).getSource(), statement) | statLabeled.get(statement.id));
                    ++var8_18;
                }
                boolean bl4 = false;
                for (Boolean val : statLabeled.values()) {
                    var8_20 += val != false;
                }
                if (precount <= var8_20) {
                    return false;
                }
                boolean bl5 = false;
                while (var9_32 < lstBreakEdges.size()) {
                    ((Statement)lstEdgeClosures.get((int)var9_32)).addLabeledEdge((StatEdge)lstBreakEdges.get((int)var9_32));
                    ++var9_32;
                }
            } else {
                return false;
            }
        }
        EliminateLoopsHelper.eliminateLoop(loop, parentloop);
        return true;
    }

    private static Statement getMaxBreakLift(Statement stat, StatEdge edge, HashMap<Integer, Boolean> statLabeled, Statement max) {
        Statement closure = stat;
        Statement newclosure = stat;
        while ((newclosure = EliminateLoopsHelper.getNextBreakLift(newclosure, edge, statLabeled, max)) != null) {
            closure = newclosure;
        }
        return closure;
    }

    private static Statement getNextBreakLift(Statement stat, StatEdge edge, HashMap<Integer, Boolean> statLabeled, Statement max) {
        for (Statement closure = stat.getParent(); closure != null && closure != max && !closure.containsStatementStrict(edge.getDestination()); closure = closure.getParent()) {
            boolean stat_labeled;
            boolean edge_labeled = LowBreakHelper.isBreakEdgeLabeled(edge.getSource(), closure);
            boolean bl = stat_labeled = statLabeled.containsKey(closure.id) ? statLabeled.get(closure.id).booleanValue() : closure.isLabeled();
            if (!stat_labeled && edge_labeled) continue;
            return closure;
        }
        return null;
    }

    private static void eliminateLoop(Statement loop, Statement parentloop) {
        ArrayList<StatEdge> lst = new ArrayList<StatEdge>(loop.getLabelEdges());
        for (StatEdge edge : lst) {
            loop.removePredecessor(edge);
            edge.getSource().changeEdgeNode(1, edge, parentloop);
            parentloop.addPredecessor(edge);
            parentloop.addLabeledEdge(edge);
        }
        Statement loopcontent = loop.getFirst();
        if (!loopcontent.getAllSuccessorEdges().isEmpty()) {
            loopcontent.removeSuccessor(loopcontent.getAllSuccessorEdges().get(0));
        }
        loop.getParent().replaceStatement(loop, loopcontent);
    }
}

