/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class DominatorTreeExceptionFilter {
    private final Statement statement;
    private final Map<Integer, Set<Integer>> mapTreeBranches = new HashMap<Integer, Set<Integer>>();
    private final Map<Integer, Set<Integer>> mapExceptionRanges = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Integer> mapExceptionDoms = new HashMap<Integer, Integer>();
    private final Map<Integer, Map<Integer, Integer>> mapExceptionRangeUniqueExit = new HashMap<Integer, Map<Integer, Integer>>();
    private DominatorEngine domEngine;

    public DominatorTreeExceptionFilter(Statement statement) {
        this.statement = statement;
    }

    public void initialize() {
        this.domEngine = new DominatorEngine(this.statement);
        this.domEngine.initialize();
        this.buildDominatorTree();
        this.buildExceptionRanges();
        this.buildFilter(this.statement.getFirst().id);
        this.mapTreeBranches.clear();
        this.mapExceptionRanges.clear();
    }

    public boolean acceptStatementPair(Integer head, Integer exit) {
        Map<Integer, Integer> filter = this.mapExceptionRangeUniqueExit.get(head);
        for (Map.Entry<Integer, Integer> entry : filter.entrySet()) {
            Integer filterExit;
            if (head.equals(this.mapExceptionDoms.get(entry.getKey())) || (filterExit = entry.getValue()) != -1 && filterExit.equals(exit)) continue;
            return false;
        }
        return true;
    }

    private void buildDominatorTree() {
        VBStyleCollection<Integer, Integer> orderedIDoms = this.domEngine.getOrderedIDoms();
        ArrayList<Integer> lstKeys = orderedIDoms.getLstKeys();
        for (int index = lstKeys.size() - 1; index >= 0; --index) {
            Integer key = (Integer)lstKeys.get(index);
            Integer idom = (Integer)orderedIDoms.get(index);
            Set<Integer> set = this.mapTreeBranches.get(idom);
            if (set == null) {
                set = new HashSet<Integer>();
                this.mapTreeBranches.put(idom, set);
            }
            set.add(key);
        }
        Integer firstid = this.statement.getFirst().id;
        this.mapTreeBranches.get(firstid).remove(firstid);
    }

    private void buildExceptionRanges() {
        for (Statement stat : this.statement.getStats()) {
            List<Statement> lstPreds = stat.getNeighbours(2, 0);
            if (lstPreds.isEmpty()) continue;
            HashSet<Integer> set = new HashSet<Integer>();
            for (Statement st : lstPreds) {
                set.add(st.id);
            }
            this.mapExceptionRanges.put(stat.id, set);
        }
        this.mapExceptionDoms = this.buildExceptionDoms(this.statement.getFirst().id);
    }

    private Map<Integer, Integer> buildExceptionDoms(Integer id) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Set<Integer> children = this.mapTreeBranches.get(id);
        if (children != null) {
            for (Integer n : children) {
                Map<Integer, Integer> mapChild = this.buildExceptionDoms(n);
                for (Integer handler : mapChild.keySet()) {
                    map.put(handler, map.containsKey(handler) ? id : mapChild.get(handler));
                }
            }
        }
        for (Map.Entry entry : this.mapExceptionRanges.entrySet()) {
            if (!((Set)entry.getValue()).contains(id)) continue;
            map.put((Integer)entry.getKey(), id);
        }
        return map;
    }

    private void buildFilter(Integer id) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Set<Integer> children = this.mapTreeBranches.get(id);
        if (children != null) {
            for (Integer childid : children) {
                this.buildFilter(childid);
                Map<Integer, Integer> mapChild = this.mapExceptionRangeUniqueExit.get(childid);
                for (Map.Entry<Integer, Set<Integer>> entry : this.mapExceptionRanges.entrySet()) {
                    Integer handler = entry.getKey();
                    Set<Integer> range = entry.getValue();
                    if (!range.contains(id)) continue;
                    Integer exit = null;
                    if (!range.contains(childid)) {
                        exit = childid;
                    } else {
                        Integer n = exit = map.containsKey(handler) ? new Integer(-1) : mapChild.get(handler);
                    }
                    if (exit == null) continue;
                    map.put(handler, exit);
                }
            }
        }
        this.mapExceptionRangeUniqueExit.put(id, map);
    }

    public DominatorEngine getDomEngine() {
        return this.domEngine;
    }
}

