/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import java.util.List;

public class LoggedErrorException
extends Exception {
    private final int mCmdLineError;
    private final List<String> mOutput;
    private final String mCmdLine;

    public LoggedErrorException(int error, List<String> output, String cmdLine) {
        this.mCmdLineError = error;
        this.mOutput = output;
        this.mCmdLine = cmdLine;
    }

    public LoggedErrorException(List<String> output) {
        this(0, output, null);
    }

    public int getCmdLineError() {
        return this.mCmdLineError;
    }

    public List<String> getOutput() {
        return this.mOutput;
    }

    public String getCmdLine() {
        return this.mCmdLine;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to run command:\n\t").append(this.mCmdLine).append('\n');
        sb.append("Error Code:\n\t").append(this.mCmdLineError).append('\n');
        if (!this.mOutput.isEmpty()) {
            sb.append("Output:\n");
            for (String line : this.mOutput) {
                sb.append('\t').append(line).append('\n');
            }
        }
        return sb.toString();
    }
}

