/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.ComparisonDetailsExtractor;
import com.intellij.rt.execution.junit.KnownException;
import com.intellij.rt.execution.junit.PacketFactory;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.Packet;
import junit.framework.ComparisonFailure;

public class FileComparisonFailure
extends ComparisonFailure
implements KnownException {
    private final String myExpected;
    private final String myActual;
    private final String myFilePath;
    private final String myActualFilePath;

    public FileComparisonFailure(String message, String expected, String actual, String filePath) {
        this(message, expected, actual, filePath, null);
    }

    public FileComparisonFailure(String message, String expected, String actual, String expectedFilePath, String actualFilePath) {
        super(message, expected, actual);
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = expectedFilePath;
        this.myActualFilePath = actualFilePath;
    }

    public String getFilePath() {
        return this.myFilePath;
    }

    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    public String getExpected() {
        return this.myExpected;
    }

    public String getActual() {
        return this.myActual;
    }

    public PacketFactory getPacketFactory() {
        return new MyPacketFactory(this, this.myExpected, this.myActual, this.myFilePath);
    }

    private static class MyPacketFactory
    extends ComparisonDetailsExtractor {
        private final String myFilePath;

        public MyPacketFactory(ComparisonFailure assertion, String expected, String actual, String filePath) {
            super((Throwable)assertion, expected, actual);
            this.myFilePath = filePath;
        }

        public Packet createPacket(OutputObjectRegistry registry, Object test) {
            Packet packet = super.createPacket(registry, test);
            packet.addLimitedString(this.myFilePath);
            return packet;
        }
    }
}

