/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public abstract class CloudModuleDeploymentRuntimeProviderBase
implements CloudDeploymentRuntimeProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudModuleDeploymentRuntimeProviderBase.class.getName()));

    public Collection<DeploymentSource> getDeploymentSources(Project project) {
        ArrayList<DeploymentSource> result = new ArrayList<DeploymentSource>();
        ModulePointerManager pointerManager = ModulePointerManager.getInstance((Project)project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            result.add((DeploymentSource)new ModuleDeploymentSourceImpl(pointerManager.create(module)));
        }
        return result;
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeploymentSource source, CloudMultiSourceServerRuntimeInstance serverRuntime, DeploymentTask<? extends CloudDeploymentNameConfiguration> deploymentTask, DeploymentLogManager logManager) throws ServerRuntimeException {
        if (!(source instanceof ModuleDeploymentSource)) {
            return null;
        }
        ModuleDeploymentSource moduleSource = (ModuleDeploymentSource)source;
        Module module = moduleSource.getModule();
        if (module == null) {
            throw new ServerRuntimeException("Module not found: " + moduleSource.getModulePointer().getModuleName());
        }
        File contentRootFile = source.getFile();
        LOG.assertTrue(contentRootFile != null, (Object)"Content root file is not found");
        return this.doCreateDeploymentRuntime(moduleSource, contentRootFile, serverRuntime, deploymentTask, logManager);
    }

    protected abstract CloudDeploymentRuntime doCreateDeploymentRuntime(ModuleDeploymentSource var1, File var2, CloudMultiSourceServerRuntimeInstance var3, DeploymentTask<? extends CloudDeploymentNameConfiguration> var4, DeploymentLogManager var5) throws ServerRuntimeException;
}

