/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtilsKt;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionWithNext;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.KtElementInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.PseudocodeTraverserKt;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.TraverseInstructionResult;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001zB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010B\u001a\u00020C2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010D\u001a\u00020C2\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020\u0016J\u0010\u0010G\u001a\u00020C2\u0006\u0010F\u001a\u00020HH\u0002J\u000e\u0010I\u001a\u00020C2\u0006\u0010=\u001a\u00020 J\u0018\u0010J\u001a\u00020C2\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020\u0016H\u0002J\u0016\u0010M\u001a\u00020C2\u0006\u0010N\u001a\u00020\u00032\u0006\u0010K\u001a\u00020\tJ\u000e\u0010O\u001a\u00020C2\u0006\u0010P\u001a\u00020QJ\b\u0010R\u001a\u00020CH\u0002J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0002J\b\u0010T\u001a\u00020\u0000H\u0016J$\u0010U\u001a\u00020\u00162\u0006\u0010F\u001a\u00020\u00162\u0012\u0010V\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020Q0WH\u0002J0\u0010X\u001a\b\u0012\u0004\u0012\u00020Q0A2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020Q0Y2\u0012\u0010V\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020Q0WH\u0002J\u001c\u0010Z\u001a\u00060\"R\u00020\u00002\u0006\u0010[\u001a\u00020\\2\b\u0010]\u001a\u0004\u0018\u00010\\J\u0014\u0010^\u001a\u0004\u0018\u00010\t2\b\u0010N\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010_\u001a\u00020\u00162\u0006\u0010`\u001a\u00020QH\u0002J\u0010\u0010a\u001a\f\u0012\b\u0012\u00060\"R\u00020\u00000\u001aJ\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010b\u001a\u00020\u0001H\u0002J\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010K\u001a\u00020\tH\u0002J\u0010\u0010d\u001a\u00020\u00162\u0006\u0010e\u001a\u00020fH\u0002J\u0018\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00160A2\b\u0010K\u001a\u0004\u0018\u00010\tH\u0016J>\u0010h\u001a.\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00030\u0003 ,*\u0015\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00030\u00030\u001a\u00a2\u0006\u0002\bi0A\u00a2\u0006\u0002\bi2\b\u0010K\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010j\u001a\u0002052\u0006\u0010F\u001a\u00020\u0016H\u0016J\b\u0010k\u001a\u00020CH\u0002J\u0006\u0010l\u001a\u00020CJ\u0018\u0010m\u001a\u00020C2\u0006\u0010F\u001a\u00020\u00162\u0006\u0010e\u001a\u00020fH\u0002J,\u0010n\u001a\u00020f2\u0006\u0010o\u001a\u00020\u00002\b\u0010p\u001a\u0004\u0018\u00010Q2\b\u0010q\u001a\u0004\u0018\u00010Q2\u0006\u0010r\u001a\u00020fH\u0002J8\u0010s\u001a\u00020C2\u0006\u0010t\u001a\u00020\u00162\u0012\u0010V\u001a\u000e\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020Q0W2\u0012\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020Q0vH\u0002J\u001e\u0010w\u001a\u00020f2\u0006\u0010p\u001a\u00020Q2\u0006\u0010q\u001a\u00020Q2\u0006\u0010x\u001a\u00020fJ\u0010\u0010y\u001a\u00020C2\u0006\u0010o\u001a\u00020\u0000H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\f\u0012\b\u0012\u00060\"R\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010#\u001a\b\u0012\u0004\u0012\u00020%0$8VX\u0096\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'Rf\u0010*\u001aZ\u0012\f\u0012\n ,*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t ,*\n\u0012\u0004\u0012\u00020\t\u0018\u00010$0$ ,*,\u0012\f\u0012\n ,*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t ,*\n\u0012\u0004\u0012\u00020\t\u0018\u00010$0$\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010/\u001a\u0004\u0018\u00010\u00012\b\u0010.\u001a\u0004\u0018\u00010\u0001@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001cR\u0011\u00109\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b:\u00101R2\u0010;\u001a&\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00160\u0016 ,*\u0012\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00160\u0016\u0018\u00010<0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?Rf\u0010@\u001aZ\u0012\f\u0012\n ,*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0016 ,*\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010A0A ,*,\u0012\f\u0012\n ,*\u0004\u0018\u00010\t0\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0016 ,*\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010A0A\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "correspondingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "getCorrespondingElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "elementsToValues", "Lcom/intellij/util/containers/BidirectionalMap;", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "enterInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "getEnterInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineEnterInstruction;", "errorInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "getErrorInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineExitInstruction;", "exitInstruction", "getExitInstruction", "instructions", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "getInstructions", "()Ljava/util/ArrayList;", "instructionsIncludingDeadCode", "", "getInstructionsIncludingDeadCode", "()Ljava/util/List;", "internalErrorInstruction", "internalExitInstruction", "internalSinkInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "labels", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$PseudocodeLabel;", "localDeclarations", "", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/LocalFunctionDeclarationInstruction;", "getLocalDeclarations", "()Ljava/util/Set;", "localDeclarations$delegate", "Lkotlin/Lazy;", "mergedValues", "Ljava/util/HashMap;", "kotlin.jvm.PlatformType", "mutableInstructionList", "<set-?>", "parent", "getParent", "()Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "setParent", "(Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;)V", "postPrecessed", "", "representativeInstructions", "reversedInstructions", "getReversedInstructions", "rootPseudocode", "getRootPseudocode", "sideEffectFree", "Ljava/util/HashSet;", "sinkInstruction", "getSinkInstruction", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/special/SubroutineSinkInstruction;", "valueUsages", "", "addErrorInstruction", "", "addExitInstruction", "addInstruction", "instruction", "addMergedValues", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MergeInstruction;", "addSinkInstruction", "addValueUsage", "value", "usage", "bindElementToValue", "element", "bindLabel", "label", "Lorg/jetbrains/kotlin/cfg/Label;", "collectAndCacheReachableInstructions", "collectReachableInstructions", "copy", "copyInstruction", "originalToCopy", "", "copyLabels", "", "createLabel", "name", "", "comment", "getElementValue", "getJumpTarget", "targetLabel", "getLabels", "pseudocode", "getMergedValues", "getNextPosition", "currentPosition", "", "getUsages", "getValueElements", "Lorg/jetbrains/annotations/Nullable;", "isSideEffectFree", "markDeadInstructions", "postProcess", "processInstruction", "repeatInternal", "originalPseudocode", "startLabel", "finishLabel", "labelCountArg", "repeatLabelsBindingForInstruction", "originalInstruction", "originalLabelsForInstruction", "Lcom/google/common/collect/Multimap;", "repeatPart", "labelCount", "repeatWhole", "PseudocodeLabel", "frontend"})
public final class PseudocodeImpl
implements Pseudocode {
    private final ArrayList<Instruction> mutableInstructionList;
    @NotNull
    private final ArrayList<Instruction> instructions;
    private final BidirectionalMap<KtElement, PseudoValue> elementsToValues;
    private final HashMap<PseudoValue, List<Instruction>> valueUsages;
    private final HashMap<PseudoValue, Set<PseudoValue>> mergedValues;
    private final HashSet<Instruction> sideEffectFree;
    @Nullable
    private Pseudocode parent;
    @NotNull
    private final Lazy<Set<LocalFunctionDeclarationInstruction>> localDeclarations$delegate;
    private final HashMap<KtElement, Instruction> representativeInstructions;
    private final ArrayList<PseudocodeLabel> labels;
    private SubroutineExitInstruction internalExitInstruction;
    private SubroutineSinkInstruction internalSinkInstruction;
    private SubroutineExitInstruction internalErrorInstruction;
    private boolean postPrecessed;
    @NotNull
    private final KtElement correspondingElement;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    public ArrayList<Instruction> getInstructions() {
        return this.instructions;
    }

    @Override
    @Nullable
    public Pseudocode getParent() {
        return this.parent;
    }

    private void setParent(Pseudocode pseudocode2) {
        this.parent = pseudocode2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<LocalFunctionDeclarationInstruction> getLocalDeclarations() {
        void $receiver$iv;
        Lazy<Set<LocalFunctionDeclarationInstruction>> lazy = this.localDeclarations$delegate;
        PseudocodeImpl pseudocodeImpl = this;
        KProperty property$iv = $$delegatedProperties[0];
        return (Set)$receiver$iv.getValue();
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalExitInstruction;
        if (subroutineExitInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Exit instruction is read before initialization"));
        }
        return subroutineExitInstruction;
    }

    @Override
    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        SubroutineSinkInstruction subroutineSinkInstruction = this.internalSinkInstruction;
        if (subroutineSinkInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Sink instruction is read before initialization"));
        }
        return subroutineSinkInstruction;
    }

    private final SubroutineExitInstruction getErrorInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.internalErrorInstruction;
        if (subroutineExitInstruction == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Error instruction is read before initialization"));
        }
        return subroutineExitInstruction;
    }

    private final Set<LocalFunctionDeclarationInstruction> getLocalDeclarations(Pseudocode pseudocode2) {
        LinkedHashSet localDeclarations2 = Sets.newLinkedHashSet();
        Pseudocode pseudocode3 = pseudocode2;
        if (pseudocode3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
        }
        for (Instruction instruction : ((PseudocodeImpl)pseudocode3).mutableInstructionList) {
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            localDeclarations2.add(instruction);
            localDeclarations2.addAll((Collection)this.getLocalDeclarations(((LocalFunctionDeclarationInstruction)instruction).getBody()));
        }
        Set set = localDeclarations2;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"localDeclarations");
        return set;
    }

    @NotNull
    public final Pseudocode getRootPseudocode() {
        for (Pseudocode parent2 = this.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            if (parent2.getParent() != null) continue;
            return parent2;
        }
        return this;
    }

    @NotNull
    public final PseudocodeLabel createLabel(@NotNull String name2, @Nullable String comment) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        PseudocodeLabel label = new PseudocodeLabel(name2, comment);
        this.labels.add(label);
        return label;
    }

    @Override
    @NotNull
    public List<Instruction> getReversedInstructions() {
        LinkedHashSet traversedInstructions = Sets.newLinkedHashSet();
        Instruction instruction = this.getSinkInstruction();
        Set set = traversedInstructions;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"traversedInstructions");
        PseudocodeTraverserKt.traverseFollowingInstructions(instruction, set, TraversalOrder.BACKWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)((Function1)null));
        if (traversedInstructions.size() < ((ArrayList)this.getInstructions()).size()) {
            ArrayList simplyReversedInstructions = Lists.newArrayList((Iterable)this.getInstructions());
            Collections.reverse(simplyReversedInstructions);
            for (Instruction instruction2 : simplyReversedInstructions) {
                if (traversedInstructions.contains(instruction2)) continue;
                Instruction instruction3 = instruction2;
                Intrinsics.checkExpressionValueIsNotNull((Object)instruction3, (String)"instruction");
                Set set2 = traversedInstructions;
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"traversedInstructions");
                PseudocodeTraverserKt.traverseFollowingInstructions(instruction3, set2, TraversalOrder.BACKWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)((Function1)null));
            }
        }
        List list2 = Lists.newArrayList((Iterable)traversedInstructions);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"Lists.newArrayList(traversedInstructions)");
        return list2;
    }

    @Override
    @NotNull
    public List<Instruction> getInstructionsIncludingDeadCode() {
        return this.mutableInstructionList;
    }

    @NotNull
    public final List<PseudocodeLabel> getLabels() {
        return this.labels;
    }

    public final void addExitInstruction(@NotNull SubroutineExitInstruction exitInstruction) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)exitInstruction, (String)"exitInstruction");
        this.addInstruction(exitInstruction);
        boolean value$iv = this.internalExitInstruction == null;
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Repeated initialization of exit instruction: " + this.internalExitInstruction + " --> " + exitInstruction;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.internalExitInstruction = exitInstruction;
    }

    public final void addSinkInstruction(@NotNull SubroutineSinkInstruction sinkInstruction) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)sinkInstruction, (String)"sinkInstruction");
        this.addInstruction(sinkInstruction);
        boolean value$iv = this.internalSinkInstruction == null;
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Repeated initialization of sink instruction: " + this.internalSinkInstruction + " --> " + sinkInstruction;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.internalSinkInstruction = sinkInstruction;
    }

    public final void addErrorInstruction(@NotNull SubroutineExitInstruction errorInstruction) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)errorInstruction, (String)"errorInstruction");
        this.addInstruction(errorInstruction);
        boolean value$iv = this.internalErrorInstruction == null;
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                String message$iv = "Repeated initialization of error instruction: " + this.internalErrorInstruction + " --> " + errorInstruction;
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        this.internalErrorInstruction = errorInstruction;
    }

    public final void addInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
        if (instruction instanceof KtElementInstruction) {
            this.representativeInstructions.put(((KtElementInstruction)instruction).getElement(), instruction);
        }
        if (instruction instanceof MergeInstruction) {
            this.addMergedValues((MergeInstruction)instruction);
        }
        for (PseudoValue inputValue : instruction.getInputValues()) {
            this.addValueUsage(inputValue, instruction);
            for (PseudoValue mergedValue : this.getMergedValues(inputValue)) {
                this.addValueUsage(mergedValue, instruction);
            }
        }
        if (PseudocodeUtilsKt.calcSideEffectFree(instruction)) {
            this.sideEffectFree.add(instruction);
        }
    }

    @Override
    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        Instruction instruction = this.mutableInstructionList.get(0);
        if (instruction == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction");
        }
        return (SubroutineEnterInstruction)instruction;
    }

    @Override
    @Nullable
    public PseudoValue getElementValue(@Nullable KtElement element2) {
        return (PseudoValue)this.elementsToValues.get((Object)element2);
    }

    @Override
    @NotNull
    public List<KtElement> getValueElements(@Nullable PseudoValue value2) {
        List list2 = this.elementsToValues.getKeysByValue((Object)value2);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Instruction> getUsages(@Nullable PseudoValue value2) {
        List list2 = this.valueUsages.get(value2);
        if (list2 == null) {
            list2 = CollectionsKt.mutableListOf((Object[])new Instruction[0]);
        }
        return list2;
    }

    @Override
    public boolean isSideEffectFree(@NotNull Instruction instruction) {
        Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
        return this.sideEffectFree.contains(instruction);
    }

    public final void bindElementToValue(@NotNull KtElement element2, @NotNull PseudoValue value2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.elementsToValues.put((Object)element2, (Object)value2);
    }

    public final void bindLabel(@NotNull Label label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Label label2 = label;
        if (label2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl.PseudocodeLabel");
        }
        ((PseudocodeLabel)label2).setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    private final Set<PseudoValue> getMergedValues(PseudoValue value2) {
        Set set = this.mergedValues.get(value2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void addMergedValues(MergeInstruction instruction) {
        LinkedHashSet<PseudoValue> result2 = new LinkedHashSet<PseudoValue>();
        for (PseudoValue value2 : instruction.getInputValues()) {
            result2.addAll((Collection)this.getMergedValues(value2));
            result2.add(value2);
        }
        this.mergedValues.put(instruction.getOutputValue(), result2);
    }

    private final void addValueUsage(PseudoValue value2, Instruction usage) {
        Object object;
        if (usage instanceof MergeInstruction) {
            return;
        }
        Map $receiver$iv = this.valueUsages;
        Object value$iv = $receiver$iv.get(value2);
        if (value$iv == null) {
            ArrayList answer$iv = Lists.newArrayList();
            $receiver$iv.put(value2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(usage);
    }

    public final void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        this.getErrorInstruction().setSink(this.getSinkInstruction());
        this.getExitInstruction().setSink(this.getSinkInstruction());
        int index2 = 0;
        Iterator<Instruction> iterator2 = this.mutableInstructionList.iterator();
        while (iterator2.hasNext()) {
            Instruction instruction;
            Instruction instruction2 = instruction = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)instruction2, (String)"instruction");
            this.processInstruction(instruction2, index2);
            ++index2;
        }
        if (this.getParent() != null) {
            return;
        }
        this.collectAndCacheReachableInstructions();
        for (LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction : this.getLocalDeclarations()) {
            Pseudocode pseudocode2 = localFunctionDeclarationInstruction.getBody();
            if (pseudocode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
            }
            ((PseudocodeImpl)pseudocode2).collectAndCacheReachableInstructions();
        }
    }

    private final void collectAndCacheReachableInstructions() {
        Set<Instruction> reachableInstructions = this.collectReachableInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!reachableInstructions.contains(instruction)) continue;
            ((ArrayList)this.getInstructions()).add(instruction);
        }
        this.markDeadInstructions();
    }

    private final void processInstruction(Instruction instruction, int currentPosition) {
        instruction.accept(new InstructionVisitor(this, currentPosition){
            final /* synthetic */ PseudocodeImpl this$0;
            final /* synthetic */ int $currentPosition;

            public void visitInstructionWithNext(@NotNull InstructionWithNext instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
            }

            public void visitJump(@NotNull AbstractJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                instruction.setResolvedTarget(PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel()));
            }

            public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                instruction.setNext(PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, PseudocodeImpl.access$getJumpTarget(this.this$0, targetLabel));
                }
            }

            public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                Instruction nextInstruction = PseudocodeImpl.access$getNextPosition(this.this$0, this.$currentPosition);
                Instruction jumpTarget = PseudocodeImpl.access$getJumpTarget(this.this$0, instruction.getTargetLabel());
                if (instruction.getOnTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            public void visitLocalFunctionDeclarationInstruction(@NotNull LocalFunctionDeclarationInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                Pseudocode pseudocode2 = instruction.getBody();
                if (pseudocode2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                }
                PseudocodeImpl body2 = (PseudocodeImpl)pseudocode2;
                PseudocodeImpl.access$setParent$p(body2, this.this$0);
                body2.postProcess();
                instruction.setNext(this.this$0.getSinkInstruction());
            }

            public void visitSubroutineExit(@NotNull SubroutineExitInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
            }

            public void visitSubroutineSink(@NotNull SubroutineSinkInstruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
            }

            public void visitInstruction(@NotNull Instruction instruction) {
                Intrinsics.checkParameterIsNotNull((Object)instruction, (String)"instruction");
                throw (Throwable)new UnsupportedOperationException(instruction.toString());
            }
            {
                this.this$0 = $outer;
                this.$currentPosition = $captured_local_variable$1;
            }
        });
    }

    private final Set<Instruction> collectReachableInstructions() {
        HashSet visited2 = Sets.newHashSet();
        Instruction instruction = this.getEnterInstruction();
        Set set = visited2;
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"visited");
        PseudocodeTraverserKt.traverseFollowingInstructions(instruction, set, TraversalOrder.FORWARD, (Function1<? super Instruction, ? extends TraverseInstructionResult>)((Function1)collectReachableInstructions.1.INSTANCE));
        if (!visited2.contains(this.getExitInstruction())) {
            visited2.add(this.getExitInstruction());
        }
        if (!visited2.contains(this.getErrorInstruction())) {
            visited2.add(this.getErrorInstruction());
        }
        if (!visited2.contains(this.getSinkInstruction())) {
            visited2.add(this.getSinkInstruction());
        }
        Set set2 = visited2;
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"visited");
        return set2;
    }

    private final void markDeadInstructions() {
        HashSet instructionSet = Sets.newHashSet((Iterable)this.getInstructions());
        for (Instruction instruction : this.mutableInstructionList) {
            if (instructionSet.contains(instruction)) continue;
            Instruction instruction2 = instruction;
            if (!(instruction2 instanceof InstructionImpl)) {
                instruction2 = null;
            }
            InstructionImpl instructionImpl = (InstructionImpl)instruction2;
            if (instructionImpl != null) {
                instructionImpl.setMarkedAsDead(true);
            }
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                Object object;
                Instruction instruction3 = nextInstruction;
                if (!(instruction3 instanceof InstructionImpl)) {
                    instruction3 = null;
                }
                Boolean bl = (object = (InstructionImpl)instruction3) != null && (object = ((InstructionImpl)object).getPreviousInstructions()) != null ? Boolean.valueOf(object.remove(instruction)) : null;
            }
        }
    }

    private final Instruction getJumpTarget(Label targetLabel) {
        Label label = targetLabel;
        if (label == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl.PseudocodeLabel");
        }
        return ((PseudocodeLabel)label).resolveToInstruction();
    }

    private final Instruction getNextPosition(int currentPosition) {
        Unit unit;
        int targetPosition = currentPosition + 1;
        boolean value$iv = targetPosition < this.mutableInstructionList.size();
        if (_Assertions.ENABLED) {
            if (!value$iv) {
                Integer message$iv = currentPosition;
                throw (Throwable)((Object)new AssertionError(message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Instruction instruction = this.mutableInstructionList.get(targetPosition);
        Intrinsics.checkExpressionValueIsNotNull((Object)instruction, (String)"mutableInstructionList[targetPosition]");
        return instruction;
    }

    @Override
    @NotNull
    public PseudocodeImpl copy() {
        PseudocodeImpl result2 = new PseudocodeImpl(this.getCorrespondingElement());
        result2.repeatWhole(this);
        return result2;
    }

    private final void repeatWhole(PseudocodeImpl originalPseudocode) {
        this.repeatInternal(originalPseudocode, null, null, 0);
        this.setParent(originalPseudocode.getParent());
    }

    public final int repeatPart(@NotNull Label startLabel, @NotNull Label finishLabel, int labelCount) {
        Intrinsics.checkParameterIsNotNull((Object)startLabel, (String)"startLabel");
        Intrinsics.checkParameterIsNotNull((Object)finishLabel, (String)"finishLabel");
        Label label = startLabel;
        if (label == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl.PseudocodeLabel");
        }
        return this.repeatInternal(((PseudocodeLabel)label).getPseudocode(), startLabel, finishLabel, labelCount);
    }

    /*
     * WARNING - void declaration
     */
    private final int repeatInternal(PseudocodeImpl originalPseudocode, Label startLabel, Label finishLabel, int labelCountArg) {
        Integer n;
        Integer n2;
        int labelCount = labelCountArg;
        if (startLabel != null) {
            Label label = startLabel;
            if (label == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl.PseudocodeLabel");
            }
            n2 = ((PseudocodeLabel)label).getTargetInstructionIndex();
        } else {
            n2 = 0;
        }
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        int startIndex = ((Number)n2).intValue();
        if (finishLabel != null) {
            Label label = finishLabel;
            if (label == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl.PseudocodeLabel");
            }
            n = ((PseudocodeLabel)label).getTargetInstructionIndex();
        } else {
            n = originalPseudocode.mutableInstructionList.size();
        }
        if (n == null) {
            Intrinsics.throwNpe();
        }
        int finishIndex = ((Number)n).intValue();
        LinkedHashMap originalToCopy = Maps.newLinkedHashMap();
        HashMultimap originalLabelsForInstruction = HashMultimap.create();
        for (PseudocodeLabel pseudocodeLabel : originalPseudocode.labels) {
            Integer n3 = pseudocodeLabel.getTargetInstructionIndex();
            if (n3 == null) {
                continue;
            }
            int index2 = ((Number)n3).intValue();
            if (pseudocodeLabel == startLabel || pseudocodeLabel == finishLabel || startIndex > index2 || index2 > finishIndex) continue;
            originalToCopy.put(pseudocodeLabel, pseudocodeLabel.copy(labelCount++));
            Label label = pseudocodeLabel;
            Intrinsics.checkExpressionValueIsNotNull((Object)label, (String)"label");
            originalLabelsForInstruction.put((Object)this.getJumpTarget(label), (Object)pseudocodeLabel);
        }
        Iterator<PseudocodeLabel> iterator2 = originalToCopy.values().iterator();
        while (iterator2.hasNext()) {
            Label label;
            Label label2 = label = (Label)iterator2.next();
            if (label2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl.PseudocodeLabel");
            }
            this.labels.add((PseudocodeLabel)label2);
        }
        int n4 = startIndex;
        int n42 = finishIndex - 1;
        if (n4 <= n42) {
            while (true) {
                void var10_16;
                Instruction originalInstruction;
                Instruction instruction = originalInstruction = originalPseudocode.mutableInstructionList.get((int)var10_16);
                Intrinsics.checkExpressionValueIsNotNull((Object)instruction, (String)"originalInstruction");
                Map map2 = originalToCopy;
                Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"originalToCopy");
                Multimap multimap = (Multimap)originalLabelsForInstruction;
                Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"originalLabelsForInstruction");
                this.repeatLabelsBindingForInstruction(instruction, map2, (Multimap<Instruction, Label>)multimap);
                Instruction instruction2 = originalInstruction;
                Intrinsics.checkExpressionValueIsNotNull((Object)instruction2, (String)"originalInstruction");
                Map map3 = originalToCopy;
                Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"originalToCopy");
                Instruction copy = this.copyInstruction(instruction2, map3);
                this.addInstruction(copy);
                if (originalInstruction == originalPseudocode.internalErrorInstruction && copy instanceof SubroutineExitInstruction) {
                    this.internalErrorInstruction = (SubroutineExitInstruction)copy;
                }
                if (originalInstruction == originalPseudocode.internalExitInstruction && copy instanceof SubroutineExitInstruction) {
                    this.internalExitInstruction = (SubroutineExitInstruction)copy;
                }
                if (originalInstruction == originalPseudocode.internalSinkInstruction && copy instanceof SubroutineSinkInstruction) {
                    this.internalSinkInstruction = (SubroutineSinkInstruction)copy;
                }
                if (var10_16 == n42) break;
                ++var10_16;
            }
        }
        if (finishIndex < this.mutableInstructionList.size()) {
            Instruction instruction = originalPseudocode.mutableInstructionList.get(finishIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)instruction, (String)"originalPseudocode.mutab\u2026tructionList[finishIndex]");
            Map map4 = originalToCopy;
            Intrinsics.checkExpressionValueIsNotNull((Object)map4, (String)"originalToCopy");
            Multimap multimap = (Multimap)originalLabelsForInstruction;
            Intrinsics.checkExpressionValueIsNotNull((Object)multimap, (String)"originalLabelsForInstruction");
            this.repeatLabelsBindingForInstruction(instruction, map4, (Multimap<Instruction, Label>)multimap);
        }
        return labelCount;
    }

    private final void repeatLabelsBindingForInstruction(Instruction originalInstruction, Map<Label, ? extends Label> originalToCopy, Multimap<Instruction, Label> originalLabelsForInstruction) {
        for (Label originalLabel : originalLabelsForInstruction.get((Object)originalInstruction)) {
            Label label = originalToCopy.get(originalLabel);
            if (label == null) {
                Intrinsics.throwNpe();
            }
            this.bindLabel(label);
        }
    }

    private final Instruction copyInstruction(Instruction instruction, Map<Label, ? extends Label> originalToCopy) {
        Label originalTarget;
        if (instruction instanceof AbstractJumpInstruction && originalToCopy.containsKey(originalTarget = ((AbstractJumpInstruction)instruction).getTargetLabel())) {
            AbstractJumpInstruction abstractJumpInstruction = (AbstractJumpInstruction)instruction;
            Label label = originalToCopy.get(originalTarget);
            if (label == null) {
                Intrinsics.throwNpe();
            }
            return abstractJumpInstruction.copy(label);
        }
        if (instruction instanceof NondeterministicJumpInstruction) {
            List<Label> originalTargets = ((NondeterministicJumpInstruction)instruction).getTargetLabels();
            List<Label> copyTargets = this.copyLabels((Collection<? extends Label>)originalTargets, originalToCopy);
            return ((NondeterministicJumpInstruction)instruction).copy(copyTargets);
        }
        Instruction instruction2 = instruction;
        if (instruction2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl");
        }
        return ((InstructionImpl)instruction2).copy();
    }

    private final List<Label> copyLabels(Collection<? extends Label> labels, Map<Label, ? extends Label> originalToCopy) {
        ArrayList newLabels = Lists.newArrayList();
        for (Label label : labels) {
            Label newLabel = originalToCopy.get(label);
            Label label2 = newLabel;
            if (label2 == null) {
                label2 = label;
            }
            newLabels.add(label2);
        }
        List list2 = newLabels;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"newLabels");
        return list2;
    }

    @Override
    @NotNull
    public KtElement getCorrespondingElement() {
        return this.correspondingElement;
    }

    public PseudocodeImpl(@NotNull KtElement correspondingElement) {
        Intrinsics.checkParameterIsNotNull((Object)correspondingElement, (String)"correspondingElement");
        this.correspondingElement = correspondingElement;
        this.mutableInstructionList = new ArrayList();
        this.instructions = new ArrayList();
        this.elementsToValues = new BidirectionalMap();
        this.valueUsages = Maps.newHashMap();
        this.mergedValues = Maps.newHashMap();
        this.sideEffectFree = Sets.newHashSet();
        this.localDeclarations$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends LocalFunctionDeclarationInstruction>>(this){
            final /* synthetic */ PseudocodeImpl this$0;

            @NotNull
            public final Set<LocalFunctionDeclarationInstruction> invoke() {
                return PseudocodeImpl.access$getLocalDeclarations(this.this$0, this.this$0);
            }
            {
                this.this$0 = pseudocodeImpl;
                super(0);
            }
        }));
        this.representativeInstructions = new HashMap();
        this.labels = new ArrayList();
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PseudocodeImpl.class), "localDeclarations", "getLocalDeclarations()Ljava/util/Set;"))};
    }

    @NotNull
    public static final /* synthetic */ Instruction access$getNextPosition(PseudocodeImpl $this, int currentPosition) {
        return $this.getNextPosition(currentPosition);
    }

    @NotNull
    public static final /* synthetic */ Instruction access$getJumpTarget(PseudocodeImpl $this, @NotNull Label targetLabel) {
        return $this.getJumpTarget(targetLabel);
    }

    @Nullable
    public static final /* synthetic */ Pseudocode access$getParent$p(PseudocodeImpl $this) {
        return $this.getParent();
    }

    public static final /* synthetic */ void access$setParent$p(PseudocodeImpl $this, @Nullable Pseudocode pseudocode2) {
        $this.setParent(pseudocode2);
    }

    @NotNull
    public static final /* synthetic */ Set access$getLocalDeclarations(PseudocodeImpl $this, @NotNull Pseudocode pseudocode2) {
        return $this.getLocalDeclarations(pseudocode2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0012\u001a\u00060\u0000R\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000bJ\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u000f\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR*\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl$PseudocodeLabel;", "Lorg/jetbrains/kotlin/cfg/Label;", "name", "", "comment", "(Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;Ljava/lang/String;Ljava/lang/String;)V", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "getPseudocode", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "<set-?>", "", "targetInstructionIndex", "getTargetInstructionIndex", "()Ljava/lang/Integer;", "setTargetInstructionIndex", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "copy", "newLabelIndex", "getName", "resolveToInstruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "", "toString", "frontend"})
    public final class PseudocodeLabel
    implements Label {
        @Nullable
        private Integer targetInstructionIndex;
        private final String name;
        private final String comment;

        @Nullable
        public final Integer getTargetInstructionIndex() {
            return this.targetInstructionIndex;
        }

        private final void setTargetInstructionIndex(Integer n) {
            this.targetInstructionIndex = n;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String toString() {
            return this.comment == null ? this.name : this.name + " [" + this.comment + "]";
        }

        public final void setTargetInstructionIndex(int targetInstructionIndex) {
            this.targetInstructionIndex = targetInstructionIndex;
        }

        @NotNull
        public final Instruction resolveToInstruction() {
            Integer index2 = this.targetInstructionIndex;
            if (index2 == null || ((Number)index2).intValue() >= PseudocodeImpl.this.mutableInstructionList.size()) {
                String message$iv = "resolveToInstruction: incorrect index " + index2 + " for label " + this.name + " " + ("in subroutine " + PseudocodeImpl.this.getCorrespondingElement().getText() + " with instructions " + PseudocodeImpl.this.mutableInstructionList);
                throw (Throwable)new IllegalStateException(message$iv.toString());
            }
            Instruction instruction = (Instruction)PseudocodeImpl.this.mutableInstructionList.get(((Number)index2).intValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)instruction, (String)"mutableInstructionList[index]");
            return instruction;
        }

        @NotNull
        public final PseudocodeLabel copy(int newLabelIndex) {
            return new PseudocodeLabel("L" + newLabelIndex, "copy of " + this.name + ", " + this.comment);
        }

        @NotNull
        public final PseudocodeImpl getPseudocode() {
            return PseudocodeImpl.this;
        }

        public PseudocodeLabel(@Nullable String name2, String comment) {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            this.name = name2;
            this.comment = comment;
        }
    }
}

