/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreter;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxedValuesCollection;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

class RedundantBoxingInterpreter
extends BoxingInterpreter {
    private static final ImmutableSet<Integer> PERMITTED_OPERATIONS_OPCODES = ImmutableSet.of((Object)58, (Object)25, (Object)87, (Object)89, (Object)192, (Object)193, (Object[])new Integer[0]);
    private static final ImmutableSet<Integer> PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER = ImmutableSet.of((Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object[])new Integer[0]);
    private final RedundantBoxedValuesCollection values = new RedundantBoxedValuesCollection();

    public RedundantBoxingInterpreter(InsnList insnList) {
        super(insnList);
    }

    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "binaryOperation"));
        }
        if (value1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value1", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "binaryOperation"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value2", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "binaryOperation"));
        }
        this.processOperationWithBoxedValue(value1, insn);
        this.processOperationWithBoxedValue(value2, insn);
        return super.binaryOperation(insn, value1, value2);
    }

    public BasicValue ternaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2, @NotNull BasicValue value3) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        if (value1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value1", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value2", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        if (value3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value3", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "ternaryOperation"));
        }
        this.processOperationWithBoxedValue(value3, insn);
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "unaryOperation"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "unaryOperation"));
        }
        if ((insn.getOpcode() == 192 || insn.getOpcode() == 193) && value2 instanceof BoxedBasicValue) {
            TypeInsnNode typeInsn = (TypeInsnNode)insn;
            if (!RedundantBoxingInterpreter.isSafeCast((BoxedBasicValue)value2, typeInsn.desc)) {
                this.markValueAsDirty((BoxedBasicValue)value2);
            }
        }
        this.processOperationWithBoxedValue(value2, insn);
        return super.unaryOperation(insn, value2);
    }

    private static boolean isSafeCast(@NotNull BoxedBasicValue value2, @NotNull String targetInternalName) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "isSafeCast"));
        }
        if (targetInternalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetInternalName", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "isSafeCast"));
        }
        if (targetInternalName.equals(Type.getInternalName(Object.class))) {
            return true;
        }
        if (targetInternalName.equals(Type.getInternalName(Number.class))) {
            return PRIMITIVE_TYPES_SORTS_WITH_WRAPPER_EXTENDS_NUMBER.contains((Object)value2.getPrimitiveType().getSort());
        }
        return value2.getType().getInternalName().equals(targetInternalName);
    }

    @NotNull
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "copyOperation"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "copyOperation"));
        }
        if (value2 instanceof BoxedBasicValue && insn.getOpcode() == 58) {
            ((BoxedBasicValue)value2).addVariableIndex(((VarInsnNode)insn).var);
        }
        this.processOperationWithBoxedValue(value2, insn);
        BasicValue basicValue = super.copyOperation(insn, value2);
        if (basicValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "copyOperation"));
        }
        return basicValue;
    }

    public void processPopInstruction(@NotNull AbstractInsnNode insnNode, @NotNull BasicValue value2) {
        if (insnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insnNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "processPopInstruction"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "processPopInstruction"));
        }
        this.processOperationWithBoxedValue(value2, insnNode);
    }

    @Override
    protected void onNewBoxedValue(@NotNull BoxedBasicValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onNewBoxedValue"));
        }
        this.values.add(value2);
    }

    @Override
    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value2, @NotNull Type resultType) {
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onUnboxing"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onUnboxing"));
        }
        if (resultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onUnboxing"));
        }
        if (value2.getPrimitiveType().equals((Object)resultType)) {
            RedundantBoxingInterpreter.addAssociatedInsn(value2, insn);
        } else {
            value2.addUnboxingWithCastTo(insn, resultType);
        }
    }

    @Override
    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMethodCallWithBoxedValue"));
        }
        this.markValueAsDirty(value2);
    }

    @Override
    protected void onMergeFail(@NotNull BoxedBasicValue v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMergeFail"));
        }
        this.markValueAsDirty(v);
    }

    @Override
    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMergeSuccess"));
        }
        if (w == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "w", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "onMergeSuccess"));
        }
        this.values.merge(v, w);
    }

    private void processOperationWithBoxedValue(@Nullable BasicValue value2, @NotNull AbstractInsnNode insnNode) {
        if (insnNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insnNode", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "processOperationWithBoxedValue"));
        }
        if (value2 instanceof BoxedBasicValue) {
            if (!PERMITTED_OPERATIONS_OPCODES.contains((Object)insnNode.getOpcode())) {
                this.markValueAsDirty((BoxedBasicValue)value2);
            } else {
                RedundantBoxingInterpreter.addAssociatedInsn((BoxedBasicValue)value2, insnNode);
            }
        }
    }

    private void markValueAsDirty(@NotNull BoxedBasicValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "markValueAsDirty"));
        }
        this.values.remove(value2);
    }

    private static void addAssociatedInsn(@NotNull BoxedBasicValue value2, @NotNull AbstractInsnNode insn) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "addAssociatedInsn"));
        }
        if (insn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insn", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "addAssociatedInsn"));
        }
        if (value2.isSafeToRemove()) {
            value2.addInsn(insn);
        }
    }

    @NotNull
    public RedundantBoxedValuesCollection getCandidatesBoxedValues() {
        RedundantBoxedValuesCollection redundantBoxedValuesCollection = this.values;
        if (redundantBoxedValuesCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/RedundantBoxingInterpreter", "getCandidatesBoxedValues"));
        }
        return redundantBoxedValuesCollection;
    }
}

