/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.handlers.GenerateLambdaKt;
import org.jetbrains.kotlin.idea.completion.handlers.ParameterNameExpression;
import org.jetbrains.kotlin.idea.core.ExpectedInfo;
import org.jetbrains.kotlin.idea.core.ExpectedInfos;
import org.jetbrains.kotlin.idea.core.ExpectedInfosKt;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u0003\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a \u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"buildTemplate", "Lcom/intellij/codeInsight/template/Template;", "lambdaType", "Lorg/jetbrains/kotlin/types/KotlinType;", "explicitParameterTypes", "", "project", "Lcom/intellij/openapi/project/Project;", "functionParameterTypes", "", "functionType", "insertLambdaTemplate", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "placeholderRange", "Lcom/intellij/openapi/util/TextRange;", "lambdaPresentation", "", "needExplicitParameterTypes", "idea-completion"})
public final class GenerateLambdaKt {
    public static final void insertLambdaTemplate(@NotNull InsertionContext context, @NotNull TextRange placeholderRange, @NotNull KotlinType lambdaType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)placeholderRange, (String)"placeholderRange");
        Intrinsics.checkParameterIsNotNull((Object)lambdaType, (String)"lambdaType");
        boolean explicitParameterTypes = GenerateLambdaKt.needExplicitParameterTypes(context, placeholderRange, lambdaType);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        String string = commandProcessor.getCurrentCommandName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String commandName = string;
        Object commandGroupId = commandProcessor.getCurrentCommandGroupId();
        RangeMarker rangeMarker = context.getDocument().createRangeMarker(placeholderRange);
        context.setLaterRunnable(new Runnable(context, commandName, commandGroupId, rangeMarker, lambdaType, explicitParameterTypes){
            final /* synthetic */ InsertionContext $context;
            final /* synthetic */ String $commandName;
            final /* synthetic */ Object $commandGroupId;
            final /* synthetic */ RangeMarker $rangeMarker;
            final /* synthetic */ KotlinType $lambdaType;
            final /* synthetic */ boolean $explicitParameterTypes;

            public final void run() {
                Project project = this.$context.getProject();
                String string = this.$commandName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandName");
                ApplicationUtilsKt.executeWriteCommand(project, string, this.$commandGroupId, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ insertLambdaTemplate.1 this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        try {
                            if (this.this$0.$rangeMarker.isValid()) {
                                this.this$0.$context.getDocument().deleteString(this.this$0.$rangeMarker.getStartOffset(), this.this$0.$rangeMarker.getEndOffset());
                                this.this$0.$context.getEditor().getCaretModel().moveToOffset(this.this$0.$rangeMarker.getStartOffset());
                                KotlinType kotlinType = this.this$0.$lambdaType;
                                boolean bl = this.this$0.$explicitParameterTypes;
                                Project project = this.this$0.$context.getProject();
                                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.getProject()");
                                Template template = GenerateLambdaKt.access$buildTemplate(kotlinType, bl, project);
                                TemplateManager.getInstance((Project)this.this$0.$context.getProject()).startTemplate(this.this$0.$context.getEditor(), template);
                            }
                        }
                        finally {
                            this.this$0.$rangeMarker.dispose();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$context = insertionContext;
                this.$commandName = string;
                this.$commandGroupId = object;
                this.$rangeMarker = rangeMarker;
                this.$lambdaType = kotlinType;
                this.$explicitParameterTypes = bl;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String lambdaPresentation(@Nullable KotlinType lambdaType) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        if (lambdaType == null) {
            return "{...}";
        }
        List<KotlinType> parameterTypes = GenerateLambdaKt.functionParameterTypes(lambdaType);
        Iterable $receiver$iv = parameterTypes;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            void var12_8 = destination$iv$iv;
            String string = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType((KotlinType)it);
            var12_8.add(string);
        }
        String parametersPresentation = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return "{ " + parametersPresentation + " -> ... }";
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean needExplicitParameterTypes(InsertionContext context, TextRange placeholderRange, KotlinType lambdaType) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Collection destination$iv$iv2;
        Collection $receiver$iv$iv$iv;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        PsiFile psiFile = context.getFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile file = (KtFile)psiFile;
        KtExpression ktExpression = (KtExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)((PsiFile)file), (int)placeholderRange.getStartOffset(), (int)placeholderRange.getEndOffset(), KtExpression.class);
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression2 = ktExpression;
        ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade(file);
        KtElement ktElement = expression2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"expression");
        BindingContext bindingContext2 = resolutionFacade2.analyze(ktElement, BodyResolveMode.PARTIAL);
        ExpectedInfos expectedInfos2 = new ExpectedInfos(bindingContext2, resolutionFacade2, false, 0, 8, null);
        KtExpression ktExpression2 = expression2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression");
        Collection<ExpectedInfo> expectedInfos3 = expectedInfos2.calculate(ktExpression2);
        Iterable iterable = expectedInfos3;
        void var10_10 = $receiver$iv2;
        Collection collection = new ArrayList();
        void var12_12 = $receiver$iv$iv2;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Boolean bl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            ExpectedInfo it = (ExpectedInfo)element$iv$iv;
            FuzzyType fuzzyType = ExpectedInfosKt.getFuzzyType(it);
            if ((fuzzyType != null ? fuzzyType.getType() : null) != null) {
                void $receiver$iv$iv$iv2;
                KotlinType kotlinType;
                kotlinType = kotlinType;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv2.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            KotlinType it = (KotlinType)element$iv$iv;
            if (!KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set functionTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (functionTypes.size() <= 1) {
            return false;
        }
        int lambdaParameterCount = KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(lambdaType).size();
        $receiver$iv$iv2 = functionTypes;
        destination$iv$iv2 = $receiver$iv;
        $receiver$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            if (!(KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(it).size() == lambdaParameterCount)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final Template buildTemplate(KotlinType lambdaType, boolean explicitParameterTypes, Project project) {
        List<KotlinType> parameterTypes = GenerateLambdaKt.functionParameterTypes(lambdaType);
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        template.setToShortenLongNames(true);
        template.addTextSegment("{ ");
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)parameterTypes)) {
            void $receiver$iv;
            ParameterNameExpression parameterNameExpression;
            int i = indexedValue.component1();
            KotlinType parameterType = (KotlinType)indexedValue.component2();
            if (i > 0) {
                template.addTextSegment(", ");
            }
            Collection collection = KotlinNameSuggester.INSTANCE.suggestNamesByType(parameterType, (Function1<? super String, Boolean>)((Function1)buildTemplate.1.INSTANCE), "p");
            ParameterNameExpression parameterNameExpression2 = parameterNameExpression;
            ParameterNameExpression parameterNameExpression3 = parameterNameExpression;
            Template template2 = template;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v1;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = stringArray;
            parameterNameExpression2((String[])objectArray);
            template2.addVariable((Expression)parameterNameExpression3, true);
            if (!explicitParameterTypes) continue;
            template.addTextSegment(": " + IdeDescriptorRenderers.SOURCE_CODE.renderType(parameterType));
        }
        template.addTextSegment(" -> ");
        template.addEndVariable();
        template.addTextSegment(" }");
        Template template3 = template;
        Intrinsics.checkExpressionValueIsNotNull((Object)template3, (String)"template");
        return template3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinType> functionParameterTypes(@NotNull KotlinType functionType) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)functionType, (String)"functionType");
        Iterable $receiver$iv = KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(functionType);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            KotlinType kotlinType = it.getType();
            collection.add(kotlinType);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final /* synthetic */ Template access$buildTemplate(@NotNull KotlinType lambdaType, boolean explicitParameterTypes, @NotNull Project project) {
        return GenerateLambdaKt.buildTemplate(lambdaType, explicitParameterTypes, project);
    }
}

