/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.findUsages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.handlers.DelegatingFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinTypeParameterFindUsagesHandler;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtil;
import org.jetbrains.kotlin.plugin.findUsages.handlers.KotlinFindUsagesHandlerDecorator;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001aH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001aH\u0002J\u0018\u0010$\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001aH\u0002J\u000e\u0010%\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0*H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/KotlinFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultOptions", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "getDefaultOptions", "()Lcom/intellij/find/findUsages/FindUsagesOptions;", "findClassOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "getFindClassOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "findFunctionOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "getFindFunctionOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "findPropertyOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "getFindPropertyOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "javaHandlerFactory", "Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "getJavaHandlerFactory", "()Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "askWhetherShouldSearchForParameterInOverridingMethods", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "canFindUsages", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "canAsk", "createFindUsagesHandlerNoDecoration", "createFindUsagesHandlerNoQuestions", "handlerForMultiple", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declarations", "", "idea"})
public final class KotlinFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @NotNull
    private final JavaFindUsagesHandlerFactory javaHandlerFactory;
    @NotNull
    private final KotlinFunctionFindUsagesOptions findFunctionOptions;
    @NotNull
    private final KotlinPropertyFindUsagesOptions findPropertyOptions;
    @NotNull
    private final KotlinClassFindUsagesOptions findClassOptions;
    @NotNull
    private final FindUsagesOptions defaultOptions;

    @NotNull
    public final JavaFindUsagesHandlerFactory getJavaHandlerFactory() {
        return this.javaHandlerFactory;
    }

    @NotNull
    public final KotlinFunctionFindUsagesOptions getFindFunctionOptions() {
        return this.findFunctionOptions;
    }

    @NotNull
    public final KotlinPropertyFindUsagesOptions getFindPropertyOptions() {
        return this.findPropertyOptions;
    }

    @NotNull
    public final KotlinClassFindUsagesOptions getFindClassOptions() {
        return this.findClassOptions;
    }

    @NotNull
    public final FindUsagesOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public boolean canFindUsages(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof KtClassOrObject || element2 instanceof KtNamedFunction || element2 instanceof KtProperty || element2 instanceof KtParameter || element2 instanceof KtTypeParameter || element2 instanceof KtConstructor;
    }

    @NotNull
    public final FindUsagesHandler createFindUsagesHandlerNoQuestions(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.createFindUsagesHandler(element2, false, false);
    }

    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.createFindUsagesHandler(element2, forHighlightUsages, !forHighlightUsages);
    }

    /*
     * WARNING - void declaration
     */
    private final FindUsagesHandler createFindUsagesHandler(PsiElement element2, boolean forHighlightUsages, boolean canAsk) {
        void $receiver$iv;
        FindUsagesHandler handler2 = this.createFindUsagesHandlerNoDecoration(element2, canAsk);
        Object[] objectArray = Extensions.getArea((AreaInstance)((AreaInstance)element2.getProject())).getExtensionPoint(KotlinFindUsagesHandlerDecorator.Companion.getEP_NAME()).getExtensions();
        FindUsagesHandler accumulator$iv = handler2;
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            void decorator;
            void element$iv = $receiver$iv[i];
            KotlinFindUsagesHandlerDecorator kotlinFindUsagesHandlerDecorator = (KotlinFindUsagesHandlerDecorator)element$iv;
            FindUsagesHandler handler3 = accumulator$iv;
            accumulator$iv = decorator.decorateHandler(element2, forHighlightUsages, handler3);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final FindUsagesHandler createFindUsagesHandlerNoDecoration(PsiElement element2, boolean canAsk) {
        PsiElement psiElement = element2;
        if (psiElement instanceof KtClassOrObject) {
            return new KotlinFindClassUsagesHandler((KtClassOrObject)element2, this);
        }
        if (psiElement instanceof KtParameter) {
            boolean hasOverridden;
            PsiMethod psiMethod;
            KtFunction function2;
            if (canAsk && (function2 = ((KtParameter)element2).getOwnerFunction()) != null && KtPsiUtilKt.isOverridable(function2) && (psiMethod = (PsiMethod)CollectionsKt.singleOrNull(LightClassUtilsKt.toLightMethods(function2))) != null && (hasOverridden = CollectionsKt.any((Iterable)((Iterable)OverridingMethodsSearch.search((PsiMethod)psiMethod)))) && this.askWhetherShouldSearchForParameterInOverridingMethods((KtParameter)element2)) {
                void $receiver$iv$iv$iv;
                Collection destination$iv$iv;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Unit unit;
                int parametersCount = psiMethod.getParameterList().getParametersCount();
                int parameterIndex2 = KtPsiUtilKt.parameterIndex(element2);
                boolean bl = parameterIndex2 < parametersCount;
                if (_Assertions.ENABLED) {
                    void value$iv;
                    if (value$iv == false) {
                        String message$iv$iv = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)message$iv$iv));
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = Unit.INSTANCE;
                }
                Iterable message$iv$iv = (Iterable)OverridingMethodsSearch.search((PsiMethod)psiMethod, (boolean)true);
                void $i$f$assert = $receiver$iv;
                Collection $i$f$assert2 = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    PsiMethod it = (PsiMethod)element$iv$iv;
                    if (!(it.getParameterList().getParametersCount() == parametersCount)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList();
                Iterable iterable = $receiver$iv$iv;
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    Boolean bl2;
                    Object element$iv$iv = element$iv$iv$iv;
                    PsiMethod it = (PsiMethod)element$iv$iv;
                    if (LightClassUtilsKt.getUnwrapped((PsiElement)it.getParameterList().getParameters()[parameterIndex2]) != null) {
                        void $receiver$iv$iv$iv2;
                        void it$iv$iv = $receiver$iv$iv$iv2;
                        bl2 = destination$iv$iv.add(it$iv$iv);
                        continue;
                    }
                    bl2 = null;
                }
                List overridingParameters = (List)destination$iv$iv;
                return this.handlerForMultiple((KtNamedDeclaration)element2, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)element2), (Iterable)overridingParameters));
            }
            return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)element2, null, this, 2, null);
        }
        if (psiElement instanceof KtNamedFunction || psiElement instanceof KtProperty || psiElement instanceof KtConstructor) {
            PsiElement psiElement2 = element2;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            }
            KtNamedDeclaration declaration = (KtNamedDeclaration)psiElement2;
            if (!canAsk) {
                return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, declaration, null, this, 2, null);
            }
            List<? extends PsiElement> declarationsToSearch = KotlinRefactoringUtil.checkSuperMethods(declaration, null, "super.methods.action.key.find.usages");
            Collection collection = declarationsToSearch;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"declarationsToSearch");
            return this.handlerForMultiple(declaration, collection);
        }
        if (psiElement instanceof KtTypeParameter) {
            return new KotlinTypeParameterFindUsagesHandler((KtNamedDeclaration)element2, this);
        }
        throw (Throwable)new IllegalArgumentException("unexpected element type: " + element2);
    }

    private final FindUsagesHandler handlerForMultiple(KtNamedDeclaration originalDeclaration, Collection<? extends PsiElement> declarations2) {
        FindUsagesHandler findUsagesHandler;
        switch (declarations2.size()) {
            case 0: {
                FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler2;
                Intrinsics.checkExpressionValueIsNotNull((Object)findUsagesHandler2, (String)"FindUsagesHandler.NULL_HANDLER");
                break;
            }
            case 1: {
                PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)CollectionsKt.single((Iterable)declarations2));
                if (psiElement == null) {
                    FindUsagesHandler findUsagesHandler3 = FindUsagesHandler.NULL_HANDLER;
                    Intrinsics.checkExpressionValueIsNotNull((Object)findUsagesHandler3, (String)"FindUsagesHandler.NULL_HANDLER");
                    return findUsagesHandler3;
                }
                PsiElement target = psiElement;
                if (target instanceof KtNamedDeclaration) {
                    findUsagesHandler = KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)target, null, this, 2, null);
                    break;
                }
                FindUsagesHandler findUsagesHandler4 = this.javaHandlerFactory.createFindUsagesHandler(target, false);
                if (findUsagesHandler4 == null) {
                    Intrinsics.throwNpe();
                }
                findUsagesHandler = findUsagesHandler4;
                Intrinsics.checkExpressionValueIsNotNull((Object)findUsagesHandler4, (String)"javaHandlerFactory.creat\u2026sHandler(target, false)!!");
                break;
            }
            default: {
                findUsagesHandler = new DelegatingFindMemberUsagesHandler(originalDeclaration, declarations2, this);
            }
        }
        return findUsagesHandler;
    }

    private final boolean askWhetherShouldSearchForParameterInOverridingMethods(KtParameter parameter) {
        return Messages.showOkCancelDialog((Project)parameter.getProject(), (String)FindBundle.message((String)"find.parameter.usages.in.overriding.methods.prompt", (Object[])new Object[]{parameter.getName()}), (String)FindBundle.message((String)"find.parameter.usages.in.overriding.methods.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public KotlinFindUsagesHandlerFactory(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.javaHandlerFactory = new JavaFindUsagesHandlerFactory(project);
        this.findFunctionOptions = new KotlinFunctionFindUsagesOptions(project);
        this.findPropertyOptions = new KotlinPropertyFindUsagesOptions(project);
        this.findClassOptions = new KotlinClassFindUsagesOptions(project);
        this.defaultOptions = new FindUsagesOptions(project);
    }
}

