/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeIndentStrategy {
    public static NodeIndentStrategy constIndent(Indent indent) {
        return new ConstIndentStrategy(indent);
    }

    public static PositionStrategy strategy(@Nullable String debugInfo) {
        return new PositionStrategy(debugInfo);
    }

    @Nullable
    public abstract Indent getIndent(@NotNull ASTNode var1);

    public static class PositionStrategy
    extends NodeIndentStrategy {
        private Indent defaultIndent = Indent.getNoneIndent();
        private final List<IElementType> in = new ArrayList<IElementType>();
        private final List<IElementType> notIn = new ArrayList<IElementType>();
        private final List<IElementType> forElement = new ArrayList<IElementType>();
        private final List<IElementType> notForElement = new ArrayList<IElementType>();
        private final String debugInfo;

        public PositionStrategy(@Nullable String debugInfo) {
            this.debugInfo = debugInfo;
        }

        public String toString() {
            return "PositionStrategy " + (this.debugInfo != null ? this.debugInfo : "No debug info");
        }

        public PositionStrategy set(Indent indent) {
            this.defaultIndent = indent;
            return this;
        }

        public PositionStrategy in(@NotNull TokenSet parents2) {
            if (parents2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "in"));
            }
            IElementType[] types2 = parents2.getTypes();
            if (types2.length == 0) {
                throw new IllegalArgumentException("Empty token set is unexpected");
            }
            PositionStrategy.fillTypes(this.in, types2[0], Arrays.copyOfRange(types2, 1, types2.length));
            return this;
        }

        public PositionStrategy in(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            if (parentType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentType", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "in"));
            }
            if (orParentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orParentTypes", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "in"));
            }
            PositionStrategy.fillTypes(this.in, parentType, orParentTypes);
            return this;
        }

        public PositionStrategy notIn(@NotNull IElementType parentType, IElementType ... orParentTypes) {
            if (parentType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentType", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "notIn"));
            }
            if (orParentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orParentTypes", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "notIn"));
            }
            PositionStrategy.fillTypes(this.notIn, parentType, orParentTypes);
            return this;
        }

        public PositionStrategy inAny() {
            this.in.clear();
            this.notIn.clear();
            return this;
        }

        public PositionStrategy forType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "forType"));
            }
            if (otherTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherTypes", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "forType"));
            }
            PositionStrategy.fillTypes(this.forElement, elementType, otherTypes);
            return this;
        }

        public PositionStrategy notForType(@NotNull IElementType elementType, IElementType ... otherTypes) {
            if (elementType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "notForType"));
            }
            if (otherTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherTypes", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "notForType"));
            }
            PositionStrategy.fillTypes(this.notForElement, elementType, otherTypes);
            return this;
        }

        public PositionStrategy forAny() {
            this.forElement.clear();
            this.notForElement.clear();
            return this;
        }

        @Override
        @Nullable
        public Indent getIndent(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$PositionStrategy", "getIndent"));
            }
            if (!this.forElement.isEmpty() && !this.forElement.contains(node.getElementType())) {
                return null;
            }
            if (this.notForElement.contains(node.getElementType())) {
                return null;
            }
            ASTNode parent2 = node.getTreeParent();
            if (parent2 != null) {
                if (!this.in.isEmpty() && !this.in.contains(parent2.getElementType())) {
                    return null;
                }
                if (this.notIn.contains(parent2.getElementType())) {
                    return null;
                }
            } else if (!this.in.isEmpty()) {
                return null;
            }
            return this.defaultIndent;
        }

        private static void fillTypes(List<IElementType> resultCollection, IElementType singleType, IElementType[] otherTypes) {
            resultCollection.clear();
            resultCollection.add(singleType);
            Collections.addAll(resultCollection, otherTypes);
        }
    }

    public static class ConstIndentStrategy
    extends NodeIndentStrategy {
        private final Indent indent;

        public ConstIndentStrategy(Indent indent) {
            this.indent = indent;
        }

        @Override
        @Nullable
        public Indent getIndent(@NotNull ASTNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/idea/formatter/NodeIndentStrategy$ConstIndentStrategy", "getIndent"));
            }
            return this.indent;
        }
    }
}

