/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.NameHighlighter;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

class LabelsHighlightingVisitor
extends KtVisitorVoid {
    private final AnnotationHolder holder;

    LabelsHighlightingVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    @Override
    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/LabelsHighlightingVisitor", "visitExpressionWithLabel"));
        }
        KtSimpleNameExpression targetLabel = expression2.getTargetLabel();
        if (targetLabel != null) {
            NameHighlighter.highlightName(this.holder, (PsiElement)targetLabel, KotlinHighlightingColors.LABEL);
        }
    }
}

